/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SeparableConvolution2D;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class SeparableConvolutionParamInitializer
implements ParamInitializer {
    private static final SeparableConvolutionParamInitializer INSTANCE = new SeparableConvolutionParamInitializer();
    public static final String DEPTH_WISE_WEIGHT_KEY = "W";
    public static final String POINT_WISE_WEIGHT_KEY = "pW";
    public static final String BIAS_KEY = "b";

    public static SeparableConvolutionParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public long numParams(NeuralNetConfiguration conf) {
        return this.numParams(conf.getLayer());
    }

    @Override
    public long numParams(Layer l) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)l;
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long pointWiseParams = this.numPointWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        return depthWiseParams + pointWiseParams + biasParams;
    }

    private long numBiasParams(SeparableConvolution2D layerConf) {
        long nOut = layerConf.getNOut();
        return layerConf.hasBias() ? nOut : 0L;
    }

    private long numDepthWiseParams(SeparableConvolution2D layerConf) {
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        int depthMultiplier = layerConf.getDepthMultiplier();
        return nIn * (long)depthMultiplier * (long)kernel[0] * (long)kernel[1];
    }

    private long numPointWiseParams(SeparableConvolution2D layerConf) {
        long nIn = layerConf.getNIn();
        long nOut = layerConf.getNOut();
        int depthMultiplier = layerConf.getDepthMultiplier();
        return nIn * (long)depthMultiplier * nOut;
    }

    @Override
    public List<String> paramKeys(Layer layer) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)layer;
        if (layerConf.hasBias()) {
            return Arrays.asList(DEPTH_WISE_WEIGHT_KEY, POINT_WISE_WEIGHT_KEY, BIAS_KEY);
        }
        return this.weightKeys(layer);
    }

    @Override
    public List<String> weightKeys(Layer layer) {
        return Arrays.asList(DEPTH_WISE_WEIGHT_KEY, POINT_WISE_WEIGHT_KEY);
    }

    @Override
    public List<String> biasKeys(Layer layer) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)layer;
        if (layerConf.hasBias()) {
            return Collections.singletonList(BIAS_KEY);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isWeightParam(Layer layer, String key) {
        return DEPTH_WISE_WEIGHT_KEY.equals(key) || POINT_WISE_WEIGHT_KEY.equals(key);
    }

    @Override
    public boolean isBiasParam(Layer layer, String key) {
        return BIAS_KEY.equals(key);
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        SeparableConvolution2D layer = (SeparableConvolution2D)conf.getLayer();
        if (layer.getKernelSize().length != 2) {
            throw new IllegalArgumentException("Filter size must be == 2");
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        SeparableConvolution2D layerConf = (SeparableConvolution2D)conf.getLayer();
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        INDArray paramsViewReshape = paramsView.reshape(new long[]{paramsView.length()});
        INDArray depthWiseWeightView = paramsViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)biasParams, (long)(biasParams + depthWiseParams))});
        INDArray pointWiseWeightView = paramsViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)(biasParams + depthWiseParams), (long)this.numParams(conf))});
        params.put(DEPTH_WISE_WEIGHT_KEY, this.createDepthWiseWeightMatrix(conf, depthWiseWeightView, initializeParams));
        conf.addVariable(DEPTH_WISE_WEIGHT_KEY);
        params.put(POINT_WISE_WEIGHT_KEY, this.createPointWiseWeightMatrix(conf, pointWiseWeightView, initializeParams));
        conf.addVariable(POINT_WISE_WEIGHT_KEY);
        if (layer.hasBias()) {
            INDArray biasView = paramsViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)biasParams)});
            params.put(BIAS_KEY, this.createBias(conf, biasView, initializeParams));
            conf.addVariable(BIAS_KEY);
        }
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)conf.getLayer();
        int[] kernel = layerConf.getKernelSize();
        long nIn = layerConf.getNIn();
        int depthMultiplier = layerConf.getDepthMultiplier();
        long nOut = layerConf.getNOut();
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        long depthWiseParams = this.numDepthWiseParams(layerConf);
        long biasParams = this.numBiasParams(layerConf);
        INDArray gradientViewReshape = gradientView.reshape(new long[]{gradientView.length()});
        INDArray depthWiseWeightGradientView = gradientViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)biasParams, (long)(biasParams + depthWiseParams))}).reshape('c', new long[]{depthMultiplier, nIn, kernel[0], kernel[1]});
        INDArray pointWiseWeightGradientView = gradientViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)(biasParams + depthWiseParams), (long)this.numParams(conf))}).reshape('c', new long[]{nOut, nIn * (long)depthMultiplier, 1L, 1L});
        out.put(DEPTH_WISE_WEIGHT_KEY, depthWiseWeightGradientView);
        out.put(POINT_WISE_WEIGHT_KEY, pointWiseWeightGradientView);
        if (layerConf.hasBias()) {
            INDArray biasGradientView = gradientViewReshape.get(new INDArrayIndex[]{NDArrayIndex.interval((long)0L, (long)nOut)});
            out.put(BIAS_KEY, biasGradientView);
        }
        return out;
    }

    protected INDArray createBias(NeuralNetConfiguration conf, INDArray biasView, boolean initializeParams) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)conf.getLayer();
        if (initializeParams) {
            biasView.assign((Number)layerConf.getBiasInit());
        }
        return biasView;
    }

    protected INDArray createDepthWiseWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)conf.getLayer();
        int depthMultiplier = layerConf.getDepthMultiplier();
        if (initializeParams) {
            int[] kernel = layerConf.getKernelSize();
            int[] stride = layerConf.getStride();
            long inputDepth = layerConf.getNIn();
            double fanIn = inputDepth * (long)kernel[0] * (long)kernel[1];
            double fanOut = (double)(depthMultiplier * kernel[0] * kernel[1]) / ((double)stride[0] * (double)stride[1]);
            long[] weightsShape = new long[]{depthMultiplier, inputDepth, kernel[0], kernel[1]};
            return layerConf.getWeightInitFn().init(fanIn, fanOut, weightsShape, 'c', weightView);
        }
        int[] kernel = layerConf.getKernelSize();
        return WeightInitUtil.reshapeWeights(new long[]{depthMultiplier, layerConf.getNIn(), kernel[0], kernel[1]}, weightView, 'c');
    }

    protected INDArray createPointWiseWeightMatrix(NeuralNetConfiguration conf, INDArray weightView, boolean initializeParams) {
        SeparableConvolution2D layerConf = (SeparableConvolution2D)conf.getLayer();
        int depthMultiplier = layerConf.getDepthMultiplier();
        if (initializeParams) {
            double fanIn;
            long inputDepth = layerConf.getNIn();
            long outputDepth = layerConf.getNOut();
            double fanOut = fanIn = (double)(inputDepth * (long)depthMultiplier);
            long[] weightsShape = new long[]{outputDepth, (long)depthMultiplier * inputDepth, 1L, 1L};
            return layerConf.getWeightInitFn().init(fanIn, fanOut, weightsShape, 'c', weightView);
        }
        return WeightInitUtil.reshapeWeights(new long[]{layerConf.getNOut(), (long)depthMultiplier * layerConf.getNIn(), 1L, 1L}, weightView, 'c');
    }
}

