/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;

public class RepeatVector
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.misc.RepeatVector> {
    public RepeatVector(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.UPSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray outEpsilon;
        this.assertInputSet(true);
        if (epsilon.dataType() != this.dataType) {
            epsilon = epsilon.castTo(this.dataType);
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
            outEpsilon = ((org.deeplearning4j.nn.conf.layers.misc.RepeatVector)this.layerConf()).getDataFormat() == RNNFormat.NCW ? epsilon.sum(new int[]{2}) : epsilon.sum(new int[]{1});
        }
        DefaultGradient gradient = new DefaultGradient();
        return new Pair((Object)gradient, (Object)outEpsilon);
    }

    protected int getN() {
        return ((org.deeplearning4j.nn.conf.layers.misc.RepeatVector)this.layerConf()).getN();
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 2) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to RepeatVector with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 2 array with shape [minibatchSize, size]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        long miniBatch = this.input.size(0);
        long size = this.input.size(1);
        if (this.getDataFormat() == RNNFormat.NCW) {
            INDArray output = this.input.reshape(new long[]{miniBatch, size, 1L}).castTo(this.dataType);
            try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
                INDArray iNDArray = output.repeat(2, new long[]{this.getN()});
                return iNDArray;
            }
        }
        INDArray output = this.input.reshape(new long[]{miniBatch, 1L, size}).castTo(this.dataType);
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            INDArray iNDArray = output.repeat(1, new long[]{this.getN()});
            return iNDArray;
        }
    }

    public RNNFormat getDataFormat() {
        return ((org.deeplearning4j.nn.conf.layers.misc.RepeatVector)this.layerConf()).getDataFormat();
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        INDArray z = this.preOutput(training, false, workspaceMgr);
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.preOutput = z.unsafeDuplication();
            }
        }
        return z;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

