/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.Convolution3DUtils;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.learning.regularization.Regularization;

public class Subsampling3DLayer
extends NoParamLayer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected int[] dilation;
    protected boolean cudnnAllowFallback = true;
    protected Convolution3D.DataFormat dataFormat = Convolution3D.DataFormat.NCDHW;

    protected Subsampling3DLayer(Builder builder) {
        super(builder);
        this.poolingType = builder.poolingType;
        if (builder.kernelSize.length != 3) {
            throw new IllegalArgumentException("Kernel size must be length 3");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 3) {
            throw new IllegalArgumentException("Invalid stride, must be length 3");
        }
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.dilation = builder.dilation;
        this.convolutionMode = builder.convolutionMode;
        this.cudnnAllowFallback = builder.cudnnAllowFallback;
        this.dataFormat = builder.dataFormat;
    }

    @Override
    public Subsampling3DLayer clone() {
        Subsampling3DLayer clone = (Subsampling3DLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        if (clone.dilation != null) {
            clone.dilation = (int[])clone.dilation.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling3DLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling3DLayer(conf, networkDataType);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Subsampling 3D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        long inChannels = ((InputType.InputTypeConvolutional3D)inputType).getChannels();
        if (inChannels > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        return InputTypeUtil.getOutputTypeCnn3DLayers(inputType, this.dataFormat, this.kernelSize, this.stride, this.padding, new int[]{1, 1, 1}, this.convolutionMode, (int)inChannels, layerIndex, this.getLayerName(), Subsampling3DLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling 3D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public List<Regularization> getRegularizationByParam(String paramName) {
        return null;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SubsamplingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        long im2colSizePerEx;
        InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
        InputType.InputTypeConvolutional3D outputType = (InputType.InputTypeConvolutional3D)this.getOutputType(-1, inputType);
        long actElementsPerEx = outputType.arrayElementsPerExample();
        long trainingWorkingSizePerEx = im2colSizePerEx = c.getChannels() * outputType.getHeight() * outputType.getWidth() * outputType.getDepth() * (long)this.kernelSize[0] * (long)this.kernelSize[1];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, Subsampling3DLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
        return this.poolingType;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public int[] getDilation() {
        return this.dilation;
    }

    public boolean isCudnnAllowFallback() {
        return this.cudnnAllowFallback;
    }

    public Convolution3D.DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
        this.poolingType = poolingType;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setDilation(int[] dilation) {
        this.dilation = dilation;
    }

    public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
        this.cudnnAllowFallback = cudnnAllowFallback;
    }

    public void setDataFormat(Convolution3D.DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Subsampling3DLayer() {
    }

    @Override
    public String toString() {
        return "Subsampling3DLayer(super=" + super.toString() + ", convolutionMode=" + this.getConvolutionMode() + ", poolingType=" + this.getPoolingType() + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", dilation=" + Arrays.toString(this.getDilation()) + ", cudnnAllowFallback=" + this.isCudnnAllowFallback() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subsampling3DLayer)) {
            return false;
        }
        Subsampling3DLayer other = (Subsampling3DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCudnnAllowFallback() != other.isCudnnAllowFallback()) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        org.deeplearning4j.nn.conf.layers.PoolingType this$poolingType = this.getPoolingType();
        org.deeplearning4j.nn.conf.layers.PoolingType other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !((Object)((Object)this$poolingType)).equals((Object)other$poolingType)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        if (!Arrays.equals(this.getDilation(), other.getDilation())) {
            return false;
        }
        Convolution3D.DataFormat this$dataFormat = this.getDataFormat();
        Convolution3D.DataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Subsampling3DLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCudnnAllowFallback() ? 79 : 97);
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        org.deeplearning4j.nn.conf.layers.PoolingType $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : ((Object)((Object)$poolingType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        result = result * 59 + Arrays.hashCode(this.getDilation());
        Convolution3D.DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    protected static abstract class BaseSubsamplingBuilder<T extends BaseSubsamplingBuilder<T>>
    extends Layer.Builder<T> {
        protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType = org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
        protected int[] kernelSize = new int[]{1, 1, 1};
        protected int[] stride = new int[]{2, 2, 2};
        protected int[] padding = new int[]{0, 0, 0};
        protected int[] dilation = new int[]{1, 1, 1};
        protected ConvolutionMode convolutionMode = ConvolutionMode.Same;
        protected boolean cudnnAllowFallback = true;

        public void setDilation(int ... dilation) {
            Preconditions.checkArgument((dilation.length == 1 || dilation.length == 3 ? 1 : 0) != 0, (String)"Must have 1 or 3 dilation values - got %s", (Object)dilation);
            if (dilation.length == 1) {
                this.dilation(dilation[0], dilation[0], dilation[0]);
            } else {
                this.dilation(dilation[0], dilation[1], dilation[2]);
            }
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
            this.setStride(stride);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.setPoolingType(poolingType.toPoolingType());
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            this.setPoolingType(poolingType);
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.setPoolingType(poolingType);
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride) {
            this.setKernelSize(kernelSize);
            this.setStride(stride);
        }

        protected BaseSubsamplingBuilder(int ... kernelSize) {
            this.setKernelSize(kernelSize);
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType) {
            this.setPoolingType(poolingType.toPoolingType());
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.setPoolingType(poolingType);
        }

        protected void setConvolutionMode(ConvolutionMode convolutionMode) {
            Preconditions.checkState((convolutionMode != ConvolutionMode.Causal ? 1 : 0) != 0, (String)"Causal convolution mode can only be used with 1D convolutional neural network layers");
            this.convolutionMode = convolutionMode;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.setConvolutionMode(convolutionMode);
            return (T)this;
        }

        public T poolingType(PoolingType poolingType) {
            this.setPoolingType(poolingType.toPoolingType());
            return (T)this;
        }

        public T poolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.setPoolingType(poolingType);
            return (T)this;
        }

        public T dilation(int dDepth, int dHeight, int dWidth) {
            this.setDilation(dDepth, dHeight, dWidth);
            return (T)this;
        }

        @Deprecated
        public T cudnnAllowFallback(boolean allowFallback) {
            this.setCudnnAllowFallback(allowFallback);
            return (T)this;
        }

        public T helperAllowFallback(boolean allowFallback) {
            this.cudnnAllowFallback = allowFallback;
            return (T)this;
        }

        public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
            return this.poolingType;
        }

        public int[] getKernelSize() {
            return this.kernelSize;
        }

        public int[] getStride() {
            return this.stride;
        }

        public int[] getPadding() {
            return this.padding;
        }

        public int[] getDilation() {
            return this.dilation;
        }

        public ConvolutionMode getConvolutionMode() {
            return this.convolutionMode;
        }

        public boolean isCudnnAllowFallback() {
            return this.cudnnAllowFallback;
        }

        public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.poolingType = poolingType;
        }

        public void setKernelSize(int[] kernelSize) {
            this.kernelSize = kernelSize;
        }

        public void setStride(int[] stride) {
            this.stride = stride;
        }

        public void setPadding(int[] padding) {
            this.padding = padding;
        }

        public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
            this.cudnnAllowFallback = cudnnAllowFallback;
        }

        public BaseSubsamplingBuilder() {
        }
    }

    public static class Builder
    extends BaseSubsamplingBuilder<Builder> {
        protected Convolution3D.DataFormat dataFormat = Convolution3D.DataFormat.NCDHW;

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            super(poolingType, kernelSize, stride);
        }

        public Builder(PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder(PoolingType poolingType) {
            super(poolingType);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            super(poolingType);
        }

        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        public Builder dataFormat(Convolution3D.DataFormat dataFormat) {
            this.setDataFormat(dataFormat);
            return this;
        }

        @Override
        public Subsampling3DLayer build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            Convolution3DUtils.validateCnn3DKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Subsampling3DLayer(this);
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate3NonNegative(kernelSize, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate3NonNegative(stride, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate3NonNegative(padding, "padding");
        }

        @Override
        public void setDilation(int ... dilation) {
            this.dilation = ValidationUtils.validate3NonNegative(dilation, "dilation");
        }

        public Builder() {
        }

        public Convolution3D.DataFormat getDataFormat() {
            return this.dataFormat;
        }

        public void setDataFormat(Convolution3D.DataFormat dataFormat) {
            this.dataFormat = dataFormat;
        }
    }

    public static enum PoolingType {
        MAX,
        AVG;


        public org.deeplearning4j.nn.conf.layers.PoolingType toPoolingType() {
            switch (this) {
                case MAX: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
                }
                case AVG: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.AVG;
                }
            }
            throw new UnsupportedOperationException("Unknown/not supported pooling type: " + this);
        }
    }
}

