/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.IterationTerminationCondition;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MaxScoreIterationTerminationCondition
implements IterationTerminationCondition {
    private double maxScore;

    public MaxScoreIterationTerminationCondition(@JsonProperty(value="maxScore") double maxScore) {
        this.maxScore = maxScore;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(double lastMiniBatchScore) {
        return lastMiniBatchScore > this.maxScore || Double.isNaN(lastMiniBatchScore);
    }

    public String toString() {
        return "MaxScoreIterationTerminationCondition(" + this.maxScore + ")";
    }

    public double getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(double maxScore) {
        this.maxScore = maxScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxScoreIterationTerminationCondition)) {
            return false;
        }
        MaxScoreIterationTerminationCondition other = (MaxScoreIterationTerminationCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMaxScore(), other.getMaxScore()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxScoreIterationTerminationCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxScore = Double.doubleToLongBits(this.getMaxScore());
        result = result * 59 + (int)($maxScore >>> 32 ^ $maxScore);
        return result;
    }
}

