/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import org.chorem.pollen.votecounting.api.model.ChoiceIdAble;

public class ChoiceScore
implements ChoiceIdAble,
Comparable<ChoiceScore>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String choiceId;
    private BigDecimal scoreValue;
    private int scoreOrder;

    public static ChoiceScore newScore(String choiceId, BigDecimal scoreValue) {
        return ChoiceScore.newScore(choiceId, scoreValue, 0);
    }

    public static ChoiceScore newScore(String choiceId, BigDecimal scoreValue, int scoreOrder) {
        ChoiceScore choiceScore = new ChoiceScore();
        choiceScore.setChoiceId(choiceId);
        choiceScore.setScoreValue(scoreValue);
        choiceScore.setScoreOrder(scoreOrder);
        return choiceScore;
    }

    @Override
    public String getChoiceId() {
        return this.choiceId;
    }

    public BigDecimal getScoreValue() {
        return this.scoreValue;
    }

    public int getScoreOrder() {
        return this.scoreOrder;
    }

    public void setScoreOrder(int scoreOrder) {
        this.scoreOrder = scoreOrder;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void addScoreValue(double scoreToAdd) {
        BigDecimal newScoreValue = this.scoreValue == null ? BigDecimal.valueOf(scoreToAdd) : this.scoreValue.add(BigDecimal.valueOf(scoreToAdd));
        this.setScoreValue(newScoreValue);
    }

    public void setScoreValue(BigDecimal scoreValue) {
        this.scoreValue = scoreValue;
    }

    @Override
    public int compareTo(ChoiceScore o) {
        return this.scoreOrder - o.scoreOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChoiceScore that = (ChoiceScore)o;
        return this.scoreOrder == that.scoreOrder && Objects.equals(this.choiceId, that.choiceId) && Objects.equals(this.scoreValue, that.scoreValue);
    }

    public int hashCode() {
        return Objects.hash(this.choiceId, this.scoreValue, this.scoreOrder);
    }

    public String toString() {
        return "ChoiceScore{choiceId='" + this.choiceId + "', scoreValue=" + String.valueOf(this.scoreValue) + ", scoreOrder=" + this.scoreOrder + "}";
    }
}

