/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;

public class BordaVoteCountingStrategy
extends AbstractVoteCountingStrategy {
    private static final Log log = LogFactory.getLog(BordaVoteCountingStrategy.class);

    public VoteCountingResult votecount(Set<Voter> voters) {
        Map scores = this.newEmptyChoiceScoreMap(voters);
        int nbChoices = scores.keySet().size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Nb choices: " + nbChoices));
        }
        Map voterSortedChoices = this.buildVoterSortedChoices(voters);
        for (Map.Entry entry : voterSortedChoices.entrySet()) {
            Voter voter = (Voter)entry.getKey();
            double weight = voter.getWeight();
            double choiceWeight = (double)nbChoices * weight;
            for (Set sortedChoiceId : (List)entry.getValue()) {
                for (String choiceId : sortedChoiceId) {
                    ((ChoiceScore)scores.get(choiceId)).addScoreValue(choiceWeight);
                }
                choiceWeight -= weight;
            }
        }
        VoteCountingResult result = this.orderByValues(scores.values());
        return result;
    }
}

