/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import java.util.HashMap;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.PasswordField;
import org.apache.tapestry5.corelib.components.TextField;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.ServiceUser;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.services.Configuration;

@IncludeStylesheet(value={"context:css/register.css"})
public class Register {
    @SessionState
    private String siteURL;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    private UserDTO newUser = new UserDTO();
    @Component
    private Form registerForm;
    @Component(id="login")
    private TextField loginField;
    @Component(id="password1")
    private PasswordField passwordField;
    @Property
    private String password1;
    @Property
    private String password2;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceAuth serviceAuth;

    Object onSuccessFromRegisterForm() {
        if (this.password1.equals(this.password2)) {
            if (this.serviceUser.createUser(this.newUser, MD5.encode((String)this.password1)) != null) {
                this.sendMailNotification();
                this.user = this.serviceAuth.isLoginRight(this.newUser.getLogin(), MD5.encode((String)this.password1));
                return "Index";
            }
            this.registerForm.recordError((Field)this.loginField, this.messages.get("loginAlreadyExists"));
            return this;
        }
        this.password1 = null;
        this.registerForm.recordError((Field)this.passwordField, this.messages.get("passwords-dont-match"));
        return this;
    }

    private void sendMailNotification() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        data.put("to", this.newUser.getEmail());
        data.put("title", this.messages.format("registerEmail_subject", new Object[]{this.newUser.getLogin()}));
        data.put("msg", this.messages.format("registerEmail_msg", new Object[]{this.newUser.getFirstName(), this.newUser.getLastName(), this.newUser.getLogin(), this.siteURL}));
        PreventRuleManager.emailAction(data);
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
    }
}

