/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.services;

import java.util.Properties;

import org.chorem.pollen.business.utils.PropertiesLoader;

/**
 * Implémentation du service de gestion de la configuration de l'application. Ce
 * service lit la configuration dans un fichier properties.
 *
 * @author rannou
 * @version $Id: ConfigurationImpl.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class ConfigurationImpl implements Configuration {

    /** Propriétés de l'application. */
    private Properties conf;

    public ConfigurationImpl() {
        conf = PropertiesLoader.loadPropertiesFile("pollen.properties");
    }

    @Override
    public Properties getConf() {
        return conf;
    }

    @Override
    public void setConf(Properties conf) {
        this.conf = conf;
    }

    @Override
    public String getProperty(String key) {
        return conf.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        conf.setProperty(key, value);
    }
}
