/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.user;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.PasswordField;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.ServiceUser;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.Lien;

/**
 * Classe de la page d'un utilisateur.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: MyAccount.java 2615 2009-07-01 13:47:45Z nrannou $
 */
@IncludeStylesheet("context:css/myAccount.css")
public class MyAccount {

    /**
     * Objet de session représentant l'utilisateur identifié.
     */
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;

    /**
     * Utilisateur dont les données sont affichées et modifiées dans le
     * formulaire
     */
    @Property
    @Persist
    private UserDTO newUser;

    @Component
    private Zone myAccountZone;

    @Component
    private Form myAccountForm;

    @Component(id = "password")
    private PasswordField passwordField;

    @Component(id = "newPassword1")
    private PasswordField newPasswordField;

    /**
     * Champ password du formulaire d'enregsitrement d'un utilisateur
     */
    @Property
    private String password;

    /**
     * Champ password1 du formulaire d'enregsitrement d'un utilisateur
     */
    @Property
    private String newPassword1;
    /**
     * Champ password2 du formulaire d'enregsitrement d'un utilisateur
     */
    @Property
    private String newPassword2;

    @Inject
    private Messages messages;

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    /**
     * Vrai lorsque l'utilisateur modifie son compte.
     */
    @SuppressWarnings("unused")
    @Property
    private boolean modify = false;

    /** Injection des services */
    @Inject
    private ServiceUser serviceManagerUser;
    @Inject
    private ServiceAuth serviceAuth;

    /**
     * Méthode appelée quand l'utilisateur modifie ses données
     *
     * @return la zone de compte mise à jour
     */
    Object onSuccessFromMyAccountForm() {

        //si l'utilisateur a renseigné le bon mot de passe
        if (serviceAuth.isLoginRight(newUser.getLogin(), MD5.encode(password)) != null) {
            if (serviceManagerUser.updateUser(newUser)) {

                //si l'utilisateur ne s'est pas trompé en répétant son mot de passe
                if (newPassword1 != null && !newPassword1.equals("")) {
                    if (newPassword1.equals(newPassword2)) {
                        serviceManagerUser.updatePasswordUser(newUser, MD5
                                .encode(newPassword1));
                        modify = false;
                    } else {
                        myAccountForm.recordError(newPasswordField, messages
                                .get("passwords-dont-match"));
                        modify = true;
                    }
                }
            }
        } else {
            myAccountForm.recordError(passwordField, "Mauvais password");
            modify = true;
        }
        return myAccountZone.getBody();
    }

    /**
     * Méthode appelée quand l'utilisateur veut modifier son compte
     *
     * @return le formulaire de modification du compte
     */
    Object onActionFromModifyButton() {
        modify = true;
        return myAccountZone.getBody();
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        newUser = user;
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null) };
    }
}
