/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.components;

import java.util.Date;
import java.util.Locale;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.Request;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.Lien;

/**
 * Classe du Layout Component Border.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: Border.java 2615 2009-07-01 13:47:45Z nrannou $
 */
@IncludeStylesheet("context:css/main.css")
public class Border {

    /** Affichage des messages pour l'utilisateur */
    @Component(id = "borderFeedback")
    private FeedBack feedback;

    /**
     * Objet de session (SSO) représentant l'adresse du site.
     */
    @SuppressWarnings("unused")
    @SessionState
    private String siteURL;

    /**
     * Hierarchie de l'adresse
     */
    @SuppressWarnings("unused")
    @Parameter(required = false)
    @Property
    private Lien[] address;

    /**
     * Chaine définissant le style de la page
     */
    @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)
    @Property
    private String pageLogo;

    /**
     * Chaine definissant le logo de la page
     */
    @SuppressWarnings("unused")
    @Property
    private String logo;

    /**
     * Lien pour l'itération
     */
    @SuppressWarnings("unused")
    @Property
    private Lien lien;

    /**
     * Champ login du formulaire d'identification
     */
    @Property
    private String login;

    /**
     * Champ password du formulaire d'identification
     */
    @Property
    private String password;

    /**
     * Objet de session représentant l'utilisateur identifié
     */
    @SuppressWarnings("unused")
    @SessionState
    @Property
    private UserDTO user;

    /**
     * vrai si l'utilisateur s'est identifié, faux sinon
     */
    @SuppressWarnings("unused")
    @Property
    private boolean userExists;

    /**
     * Locale permettant le changement de langue
     */
    @Inject
    private PersistentLocale localeService;

    /**
     * Accès à la requête
     */
    @Inject
    private Request request;

    /**
     * Accès aux messages
     */
    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServiceAuth serviceAuth;

    /**
     * Methode appelée lorsque l'utilisateur s'identifie. L'utilisateur est
     * retrouvé grâce au service d'authentification.
     *
     * @return la zone à mettre à jour
     */
    Object onSuccessFromLoginForm() {
        UserDTO userDTO = serviceAuth.isLoginRight(login, MD5.encode(password));
        if (userDTO != null) {
            user = userDTO;
            feedback.addInfo(messages.get("loginOk"));
        } else {
            feedback.addError(messages.get("loginFailed"));
        }
        return null;
    }

    /**
     * Methode appelée lorsque l'utilisateur se déconnecte. L'objet user est
     * désinstancié (=null).
     *
     * @return la zone à mettre à jour
     */
    Object onActionFromLogout() {
        user = null;
        return "Index";
    }

    /**
     * Méthode appelée lorsque l'utilisateur choisit la langue française
     */
    void onActionFromLocaleFr() {
        localeService.set(Locale.FRENCH);
    }

    /**
     * Méthode appelée lorsque l'utilisateur choisit la langue anglaise
     */
    void onActionFromLocaleEn() {
        localeService.set(Locale.ENGLISH);
    }

    /**
     * Date et heure actuelles.
     */
    public Date getCurrentTime() {
        return new Date();
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {

        // URL du site
        siteURL = "http://" + request.getHeader("host")
                + request.getContextPath() + "/";

        // Logo
        if (localeService != null && localeService.get() != null
                && Locale.FRENCH.equals(localeService.get()))
            logo = "pollen" + pageLogo + "_fr.png";
        else
            logo = "pollen" + pageLogo + "_en.png";
    }
}
