/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

public class DeleteFavoriteListVoter
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected String favoriteListId;
    protected String pollAccountId;
    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setFavoriteListId(String favoriteListId) {
        this.favoriteListId = favoriteListId;
    }

    public void setPollAccountId(String pollAccountId) {
        this.pollAccountId = pollAccountId;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.pollAccountId);
        FavoriteService service = this.getFavoriteService();
        PersonList favoriteList = (PersonList)service.getEntityById(PersonList.class, this.favoriteListId);
        PollAccount pollAccount = (PollAccount)service.getEntityById(PollAccount.class, this.pollAccountId);
        service.removePollAccountToFavoriteList(favoriteList, pollAccount);
        this.addFlashMessage(this._("pollen.information.pollAccount.removedFromFavoriteList", new Object[]{pollAccount.getVotingId()}));
        return "success";
    }
}

