/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ManageUsers.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/admin/ManageUsers.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.admin;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.nuiton.util.StringUtil;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ManageUsers extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String action;

    protected UserAccount user;

    public UserAccount getUser() {
        if (user == null) {
            user = getUserService().getNewUser();
        }
        return user;
    }

    public UserAccount getCreateUser() {
        return getUser();
    }

    public UserAccount getEditUser() {
        return getUser();
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public void validate() {

        if ("create".equals(action)) {

            UserAccount account = getCreateUser();

            if (StringUtils.isBlank(account.getLogin())) {
                addFieldError("createUser.login",
                              _("pollen.error.login.required"));
            }

            if (StringUtils.isBlank(account.getEmail())) {
                addFieldError("createUser.email",
                              _("pollen.error.email.required"));
            } else if (!StringUtil.isEmail(account.getEmail())) {
                addFieldError("createUser.email",
                              _("pollen.error.email.invalid"));
            }
        } else if ("edit".equals(action)) {

            UserAccount account = getEditUser();

            if (StringUtils.isBlank(account.getLogin())) {
                addFieldError("editUser.login",
                              _("pollen.error.pollAccount.votingId.required"));
            }

            if (StringUtils.isBlank(account.getEmail())) {
                addFieldError("editUser.email",
                              _("pollen.error.email.required"));
            } else if (!StringUtil.isEmail(account.getEmail())) {
                addFieldError("editUser.email",
                              _("pollen.error.email.invalid"));
            }
        }
    }

    public String create() throws Exception {

        Preconditions.checkNotNull(user);

        String result = INPUT;
        try {
            getUserService().createUser(user, true);

            addFlashMessage(
                    _("pollen.information.user.created",
                      user.getDisplayName()));
            // remove this user, otherwise it will be reused in the user lists
            user = null;
            action = null;
            result = SUCCESS;
        } catch (UserLoginAlreadyUsedException e) {
            addFieldError("createUser.login",
                          _("pollen.error.user.login.already.used"));

        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("createUser.email",
                          _("pollen.error.user.email.already.used"));
        }

        return result;
    }

    public String edit() throws Exception {

        Preconditions.checkNotNull(user);

        String result = INPUT;

        try {
            getUserService().updateUser(user, null, true);
            addFlashMessage(
                    _("pollen.information.user.updated",
                      user.getDisplayName()));

            // remove this user, otherwise it will be reused in the user lists
            user = null;
            action = null;
            result = SUCCESS;
        } catch (UserEmailAlreadyUsedException e) {
            addFieldError("editUser.email",
                          _("pollen.error.user.email.already.used"));
        } catch (UserInvalidPasswordException e) {
            addFieldError("editUser.password",
                          _("pollen.error.user.invalid.password"));
        }
        return result;
    }

    public boolean isExists() {
        return StringUtils.isNotBlank(user.getTopiaId());
    }
}
