/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.io;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

public class GenerateChart
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GenerateChart.class);
    public static final int PIE = 1;
    public static final int PIE3D = 2;
    public static final int RING = 3;
    protected int type;
    protected List<String> values;
    protected List<String> subtitles;
    protected int width;
    protected int height;
    protected String title;
    protected JFreeChart chart;

    public void setType(int type) {
        this.type = type;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setSubtitles(List<String> subtitles) {
        this.subtitles = subtitles;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String execute() throws Exception {
        PiePlot plot;
        DefaultKeyedValues vals = new DefaultKeyedValues();
        if (log.isInfoEnabled()) {
            log.info((Object)("Title     = " + this.title));
            log.info((Object)("Values    = " + this.values));
            log.info((Object)("Subtitles = " + this.subtitles));
        }
        int nbValues = this.values.size() / 2;
        for (int i = 0; i < nbValues; ++i) {
            String key = (String)this.values.get(2 * i);
            Double value = Double.valueOf((String)this.values.get(2 * i + 1));
            vals.addValue((Comparable)((Object)key), (Number)value);
        }
        vals.sortByValues(SortOrder.DESCENDING);
        DefaultPieDataset data = new DefaultPieDataset((KeyedValues)vals);
        switch (this.type) {
            case 1: {
                plot = new PiePlot((PieDataset)data);
                break;
            }
            case 2: {
                plot = new PiePlot3D((PieDataset)data);
                break;
            }
            case 3: {
                plot = new RingPlot((PieDataset)data);
                break;
            }
            default: {
                plot = new PiePlot((PieDataset)data);
            }
        }
        plot.setCircular(true);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} {2}"));
        plot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1}"));
        plot.setNoDataMessage("No Data");
        this.chart = new JFreeChart((Plot)plot);
        this.chart.setTitle(new TextTitle(this.title, new Font("SansSerif", 1, 12)));
        this.chart.setBackgroundPaint((Paint)new Color(255, 255, 255));
        if (CollectionUtils.isNotEmpty((Collection)this.subtitles)) {
            Font subtitlesFont = new Font("SansSerif", 2, 11);
            for (int i = 0; i < this.subtitles.size(); i += 2) {
                String subtitle = (String)this.subtitles.get(i) + "=" + (String)this.subtitles.get(i + 1);
                TextTitle textTitle = new TextTitle(subtitle, subtitlesFont);
                this.chart.addSubtitle((Title)textTitle);
            }
        }
        return "success";
    }
}

