/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.json.AbstractJSONPaginedAction;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;

public class GetPolls
extends AbstractJSONPaginedAction {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, Object>[] data;

    public Map<String, Object>[] getData() {
        return this.data;
    }

    public String execute() throws Exception {
        PollService pollService = this.getPollService();
        List pollList = pollService.getPolls(this.pager);
        this.data = new Map[pollList.size()];
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Poll poll : pollList) {
            Map map = pollService.pollToMap(poll, (Binder)binder);
            map.put("adminId", poll.getAdminId());
            map.put("functions", Sets.newHashSet((Object[])new String[]{"summary"}));
            this.data[index++] = map;
        }
        return "success";
    }
}

