/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DateConverter.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/converters/DateConverter.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.converters;

import com.opensymphony.xwork2.ActionContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.util.StrutsTypeConverter;
import org.nuiton.util.DateUtil;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

import static org.nuiton.i18n.I18n.l_;

/**
 * Created: 18/04/12
 *
 * @author fdesbois <desbois@codelutin.com>
 * @since 1.3
 */
public class DateConverter extends StrutsTypeConverter {

    private static final Log log = LogFactory.getLog(DateConverter.class);

    @Override
    public Date convertFromString(Map context, String[] values, Class toClass) {
        String value = values[0];
        Date result = convertFromString(value);
        return result;
    }

    @Override
    public String convertToString(Map context, Object o) {
        Date date = (Date) o;
        String result = convertToString(date);
        return result;
    }

    public static String convertToString(Date date) {
        String result = DateUtil.formatDate(date, getDateTimePattern());
        return result;
    }

    public static Date convertFromString(String value) {
        Date result = null;
        if (StringUtils.isNotBlank(value)) {
            // try first with a date-time pattern
            try {
                result = DateUtil.parseDate(value, getDateTimePattern());
            } catch (ParseException e) {

                // fall-back, try with a date pattern
                try {
                    result = DateUtil.parseDate(value, getDatePattern());
                } catch (ParseException e1) {
                    if (log.isErrorEnabled()) {
                        log.error("Error parsing date '" + value + "'", e1);
                    }
                }
            }
        }
        return result;
    }

    private static String getDateTimePattern() {
        Locale locale = ActionContext.getContext().getLocale();
        String result = l_(locale, "pollen.common.dateTimePattern");
        return result;
    }

    private static String getDatePattern() {
        Locale locale = ActionContext.getContext().getLocale();
        String result = l_(locale, "pollen.common.datePattern");
        return result;
    }
}
