package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class VotingListAbstract extends TopiaEntityAbstract implements VotingList {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : weight
     */
    protected double weight;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected List<PersonToList> pollAccountPersonToList;

    /**
     * Nom de l'attribut en BD : vote
     */
    protected Vote vote;

    private static final long serialVersionUID = 3702628738512741732L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_WEIGHT, double.class, weight);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, List.class, PersonToList.class, pollAccountPersonToList);
        visitor.visit(this, PROPERTY_VOTE, Vote.class, vote);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setWeight(double weight) {
        double oldValue = this.weight;
        fireOnPreWrite(PROPERTY_WEIGHT, oldValue, weight);
        this.weight = weight;
        fireOnPostWrite(PROPERTY_WEIGHT, oldValue, weight);
    }

    @Override
    public double getWeight() {
        fireOnPreRead(PROPERTY_WEIGHT, weight);
        double result = this.weight;
        fireOnPostRead(PROPERTY_WEIGHT, weight);
        return result;
    }

    @Override
    public void addPollAccountPersonToList(PersonToList pollAccountPersonToList) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, null, pollAccountPersonToList);
        if (this.pollAccountPersonToList == null) {
            this.pollAccountPersonToList = new ArrayList<PersonToList>();
        }

        this.pollAccountPersonToList.add(pollAccountPersonToList);
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, this.pollAccountPersonToList.size(), null, pollAccountPersonToList);
    }

    @Override
    public void addAllPollAccountPersonToList(List<PersonToList> pollAccountPersonToList) {
        if (pollAccountPersonToList == null) {
            return;
        }
        for (PersonToList item : pollAccountPersonToList) {
            addPollAccountPersonToList(item);
        }
    }

    @Override
    public void setPollAccountPersonToList(List<PersonToList> pollAccountPersonToList) {
        // Copy elements to keep data for fire with new reference
        List<PersonToList> oldValue = this.pollAccountPersonToList != null ? new ArrayList<PersonToList>(this.pollAccountPersonToList) : null;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, oldValue, pollAccountPersonToList);
        this.pollAccountPersonToList = pollAccountPersonToList;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, oldValue, pollAccountPersonToList);
    }

    @Override
    public void removePollAccountPersonToList(PersonToList pollAccountPersonToList) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, pollAccountPersonToList, null);
        if (this.pollAccountPersonToList == null || !this.pollAccountPersonToList.remove(pollAccountPersonToList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, this.pollAccountPersonToList.size() + 1, pollAccountPersonToList, null);
    }

    @Override
    public void clearPollAccountPersonToList() {
        if (this.pollAccountPersonToList == null) {
            return;
        }
        for (PersonToList item : this.pollAccountPersonToList) {
        }
        List<PersonToList> oldValue = new ArrayList<PersonToList>(this.pollAccountPersonToList);
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, oldValue, this.pollAccountPersonToList);
        this.pollAccountPersonToList.clear();
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT_PERSON_TO_LIST, oldValue, this.pollAccountPersonToList);
    }

    @Override
    public List<PersonToList> getPollAccountPersonToList() {
        return pollAccountPersonToList;
    }

    @Override
    public PersonToList getPollAccountPersonToListByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pollAccountPersonToList, topiaId);
    }

    @Override
    public PersonToList getPollAccountPersonToList(PollAccount pollAccount) {
        if (pollAccount == null || this.pollAccountPersonToList == null) {
            return null;
        }
        for (PersonToList item : this.pollAccountPersonToList) {
            if (pollAccount.equals(item.getPollAccount())) {
                return item;
            }
        }
        return null;
    }

    @Override
    public int sizePollAccountPersonToList() {
        if (pollAccountPersonToList == null) {
            return 0;
        }
        return pollAccountPersonToList.size();
    }

    @Override
    public boolean isPollAccountPersonToListEmpty() {
        int size = sizePollAccountPersonToList();
        return size == 0;
    }

    @Override
    public void setVote(Vote vote) {
        Vote oldValue = this.vote;
        fireOnPreWrite(PROPERTY_VOTE, oldValue, vote);
        this.vote = vote;
        fireOnPostWrite(PROPERTY_VOTE, oldValue, vote);
    }

    @Override
    public Vote getVote() {
        fireOnPreRead(PROPERTY_VOTE, vote);
        Vote result = this.vote;
        fireOnPostRead(PROPERTY_VOTE, vote);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<PersonToList> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(PersonToList.class);
            List<PersonToList> findAllByProperties = dao.findAllByProperties("votingList", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //VotingListAbstract
