package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PollDAOAbstract<E extends Poll> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Poll.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.Poll;
    }

    public E findByNaturalId(String pollId) throws TopiaException {
        return findByProperties(Poll.PROPERTY_POLL_ID, pollId);
    }

    public boolean existByNaturalId(String pollId) throws TopiaException {
        return existByProperties(Poll.PROPERTY_POLL_ID, pollId);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param pollId 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E createByNaturalId(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E createByNotNull(String pollId) throws TopiaException {
        return create(Poll.PROPERTY_POLL_ID, pollId);
    }

    public E findByPollId(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_ID, v);
        return result;
    }

    public List<E> findAllByPollId(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_ID, v);
        return result;
    }

    public E findByTitle(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_TITLE, v);
        return result;
    }

    public List<E> findAllByTitle(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_TITLE, v);
        return result;
    }

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_DESCRIPTION, v);
        return result;
    }

    public E findByBeginChoiceDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_BEGIN_CHOICE_DATE, v);
        return result;
    }

    public List<E> findAllByBeginChoiceDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_BEGIN_CHOICE_DATE, v);
        return result;
    }

    public E findByBeginDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_BEGIN_DATE, v);
        return result;
    }

    public List<E> findAllByBeginDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_BEGIN_DATE, v);
        return result;
    }

    public E findByEndDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_END_DATE, v);
        return result;
    }

    public List<E> findAllByEndDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_END_DATE, v);
        return result;
    }

    public E findByMaxChoiceNb(int v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_MAX_CHOICE_NB, v);
        return result;
    }

    public List<E> findAllByMaxChoiceNb(int v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_MAX_CHOICE_NB, v);
        return result;
    }

    public E findByClosed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CLOSED, v);
        return result;
    }

    public List<E> findAllByClosed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CLOSED, v);
        return result;
    }

    public E findByChoiceAddAllowed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CHOICE_ADD_ALLOWED, v);
        return result;
    }

    public List<E> findAllByChoiceAddAllowed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CHOICE_ADD_ALLOWED, v);
        return result;
    }

    public E findByAnonymousVoteAllowed(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED, v);
        return result;
    }

    public List<E> findAllByAnonymousVoteAllowed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED, v);
        return result;
    }

    public E findByPublicResults(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_PUBLIC_RESULTS, v);
        return result;
    }

    public List<E> findAllByPublicResults(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_PUBLIC_RESULTS, v);
        return result;
    }

    public E findByContinuousResults(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CONTINUOUS_RESULTS, v);
        return result;
    }

    public List<E> findAllByContinuousResults(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CONTINUOUS_RESULTS, v);
        return result;
    }

    public E findByEndChoiceDate(Date v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_END_CHOICE_DATE, v);
        return result;
    }

    public List<E> findAllByEndChoiceDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_END_CHOICE_DATE, v);
        return result;
    }

    public E findByResultUptodate(boolean v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_RESULT_UPTODATE, v);
        return result;
    }

    public List<E> findAllByResultUptodate(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_RESULT_UPTODATE, v);
        return result;
    }

    public E findByVoteCountingType(int v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    public List<E> findAllByVoteCountingType(int v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_VOTE_COUNTING_TYPE, v);
        return result;
    }

    public E findContainsVote(Vote v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_VOTE, v);
        return result;
    }

    public List<E> findAllContainsVote(Vote v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_VOTE, v);
        return result;
    }

    public E findContainsChoice(Choice v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_CHOICE, v);
        return result;
    }

    public List<E> findAllContainsChoice(Choice v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_CHOICE, v);
        return result;
    }

    public E findContainsResult(Result v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_RESULT, v);
        return result;
    }

    public List<E> findAllContainsResult(Result v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_RESULT, v);
        return result;
    }

    public E findByCreator(PollAccount v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CREATOR, v);
        return result;
    }

    public List<E> findAllByCreator(PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CREATOR, v);
        return result;
    }

    public E findContainsComment(Comment v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllContainsComment(Comment v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsPreventRule(PreventRule v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_PREVENT_RULE, v);
        return result;
    }

    public List<E> findAllContainsPreventRule(PreventRule v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_PREVENT_RULE, v);
        return result;
    }

    public E findContainsVotingList(VotingList v) throws TopiaException {
        E result = findContains(Poll.PROPERTY_VOTING_LIST, v);
        return result;
    }

    public List<E> findAllContainsVotingList(VotingList v) throws TopiaException {
        List<E> result = findAllContains(Poll.PROPERTY_VOTING_LIST, v);
        return result;
    }

    public E findByPollType(PollType v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_TYPE, v);
        return result;
    }

    public List<E> findAllByPollType(PollType v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_TYPE, v);
        return result;
    }

    public E findByChoiceType(ChoiceType v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_CHOICE_TYPE, v);
        return result;
    }

    public List<E> findAllByChoiceType(ChoiceType v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_CHOICE_TYPE, v);
        return result;
    }

    public E findByPollVoteVisibility(PollVoteVisibility v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_VOTE_VISIBILITY, v);
        return result;
    }

    public List<E> findAllByPollVoteVisibility(PollVoteVisibility v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_VOTE_VISIBILITY, v);
        return result;
    }

    public E findByPollCommentVisibility(PollCommentVisibility v) throws TopiaException {
        E result = findByProperty(Poll.PROPERTY_POLL_COMMENT_VISIBILITY, v);
        return result;
    }

    public List<E> findAllByPollCommentVisibility(PollCommentVisibility v) throws TopiaException {
        List<E> result = findAllByProperty(Poll.PROPERTY_POLL_COMMENT_VISIBILITY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }

} //PollDAOAbstract<E extends Poll>
