/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAOAbstract;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaQuery;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class UserAccountDAOImpl<E extends UserAccount>
extends UserAccountDAOAbstract<E> {
    public boolean isUserExist(UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)user);
        TopiaQuery query = this.createQuery().addWhere("login", TopiaQuery.Op.NEQ, (Object)user.getLogin());
        query.addEquals("email", new Object[]{StringUtils.lowerCase((String)user.getEmail())});
        boolean result = this.existByQuery(query);
        return result;
    }

    public List<E> getUsers(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        long records = this.count();
        pager.setRecords((int)records);
        TopiaQuery query = this.createQuery("e");
        TopiaFilterPagerUtil.addPagerToQuery((TopiaQuery)query, (TopiaFilterPagerUtil.FilterPagerBean)pager);
        List result = this.findAllByQuery(query);
        return result;
    }
}

