/*
 * #%L
 * Pollen :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PollAccountDAOAbstract<E extends PollAccount> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)PollAccount.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.PollAccount;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Poll> list = getContext()
                                                    .getDAO(Poll.class)
                                                    .findAllByProperties(Poll.PROPERTY_CREATOR, entity);
                                            for (Poll item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getCreator())) {
                                                    item.setCreator(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Comment> list = getContext()
                                                    .getDAO(Comment.class)
                                                    .findAllByProperties(Comment.PROPERTY_POLL_ACCOUNT, entity);
                                            for (Comment item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPollAccount())) {
                                                    item.setPollAccount(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Vote> list = getContext()
                                                    .getDAO(Vote.class)
                                                    .findAllByProperties(Vote.PROPERTY_POLL_ACCOUNT, entity);
                                            for (Vote item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPollAccount())) {
                                                    item.setPollAccount(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByAccountId(String v) throws TopiaException {
        E result = findByProperty(PollAccount.PROPERTY_ACCOUNT_ID, v);
        return result;
    }

    public List<E> findAllByAccountId(String v) throws TopiaException {
        List<E> result = findAllByProperty(PollAccount.PROPERTY_ACCOUNT_ID, v);
        return result;
    }

    public E findByVotingId(String v) throws TopiaException {
        E result = findByProperty(PollAccount.PROPERTY_VOTING_ID, v);
        return result;
    }

    public List<E> findAllByVotingId(String v) throws TopiaException {
        List<E> result = findAllByProperty(PollAccount.PROPERTY_VOTING_ID, v);
        return result;
    }

    public E findByEmail(String v) throws TopiaException {
        E result = findByProperty(PollAccount.PROPERTY_EMAIL, v);
        return result;
    }

    public List<E> findAllByEmail(String v) throws TopiaException {
        List<E> result = findAllByProperty(PollAccount.PROPERTY_EMAIL, v);
        return result;
    }

    public E findContainsPollsCreated(Poll v) throws TopiaException {
        E result = findContains(PollAccount.PROPERTY_POLLS_CREATED, v);
        return result;
    }

    public List<E> findAllContainsPollsCreated(Poll v) throws TopiaException {
        List<E> result = findAllContains(PollAccount.PROPERTY_POLLS_CREATED, v);
        return result;
    }

    public E findContainsComment(Comment v) throws TopiaException {
        E result = findContains(PollAccount.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllContainsComment(Comment v) throws TopiaException {
        List<E> result = findAllContains(PollAccount.PROPERTY_COMMENT, v);
        return result;
    }

    public E findContainsVote(Vote v) throws TopiaException {
        E result = findContains(PollAccount.PROPERTY_VOTE, v);
        return result;
    }

    public List<E> findAllContainsVote(Vote v) throws TopiaException {
        List<E> result = findAllContains(PollAccount.PROPERTY_VOTE, v);
        return result;
    }

    public E findByPersonList(PersonList v) throws TopiaException {
        E result = findByProperty(PollAccount.PROPERTY_PERSON_LIST, v);
        return result;
    }

    public List<E> findAllByPersonList(PersonList v) throws TopiaException {
        List<E> result = findAllByProperty(PollAccount.PROPERTY_PERSON_LIST, v);
        return result;
    }

    public E findByUserAccount(UserAccount v) throws TopiaException {
        E result = findByProperty(PollAccount.PROPERTY_USER_ACCOUNT, v);
        return result;
    }

    public List<E> findAllByUserAccount(UserAccount v) throws TopiaException {
        List<E> result = findAllByProperty(PollAccount.PROPERTY_USER_ACCOUNT, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == UserAccount.class) {
            UserAccountDAO dao = (UserAccountDAO)
                getContext().getDAO(UserAccount.class);
            tmp = dao.findAllContainsPollAccount(entity);
            result.addAll(tmp);
        }

        if (type == Vote.class) {
            VoteDAO dao = (VoteDAO)
                getContext().getDAO(Vote.class);
            tmp = dao.findAllByPollAccount(entity);
            result.addAll(tmp);
        }

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllByCreator(entity);
            result.addAll(tmp);
        }

        if (type == Comment.class) {
            CommentDAO dao = (CommentDAO)
                getContext().getDAO(Comment.class);
            tmp = dao.findAllByPollAccount(entity);
            result.addAll(tmp);
        }

        if (type == PersonList.class) {
            PersonListDAO dao = (PersonListDAO)
                getContext().getDAO(PersonList.class);
            tmp = dao.findAllContainsPollAccount(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(5);

        List<? extends TopiaEntity> list;

        list = findUsages(UserAccount.class, entity);
        if (!list.isEmpty()) {
            result.put(UserAccount.class, list);
        }

        list = findUsages(Vote.class, entity);
        if (!list.isEmpty()) {
            result.put(Vote.class, list);
        }

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        list = findUsages(Comment.class, entity);
        if (!list.isEmpty()) {
            result.put(Comment.class, list);
        }

        list = findUsages(PersonList.class, entity);
        if (!list.isEmpty()) {
            result.put(PersonList.class, list);
        }

        return result;
    }

} //PollAccountDAOAbstract<E extends PollAccount>
