/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;

public class PollenModelDAOHelper {

    /**
     * no instance for this helper
     */
    protected PollenModelDAOHelper() {
    }

    /**
     * Model version.
     * 
     * @return model version
     */
    public static String getModelVersion() {
        return "1.2";
    }

    public static ChoiceDAO getChoiceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ChoiceDAO result = (ChoiceDAO) ci.getDAO(Choice.class);
        return result;
    }

    public static ChoiceTypeDAO getChoiceTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ChoiceTypeDAO result = (ChoiceTypeDAO) ci.getDAO(ChoiceType.class);
        return result;
    }

    public static CommentDAO getCommentDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CommentDAO result = (CommentDAO) ci.getDAO(Comment.class);
        return result;
    }

    public static PersonListDAO getPersonListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonListDAO result = (PersonListDAO) ci.getDAO(PersonList.class);
        return result;
    }

    public static PersonToListDAO getPersonToListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonToListDAO result = (PersonToListDAO) ci.getDAO(PersonToList.class);
        return result;
    }

    public static PollDAO getPollDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollDAO result = (PollDAO) ci.getDAO(Poll.class);
        return result;
    }

    public static PollAccountDAO getPollAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollAccountDAO result = (PollAccountDAO) ci.getDAO(PollAccount.class);
        return result;
    }

    public static PollTypeDAO getPollTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollTypeDAO result = (PollTypeDAO) ci.getDAO(PollType.class);
        return result;
    }

    public static PreventRuleDAO getPreventRuleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PreventRuleDAO result = (PreventRuleDAO) ci.getDAO(PreventRule.class);
        return result;
    }

    public static ResultDAO getResultDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ResultDAO result = (ResultDAO) ci.getDAO(Result.class);
        return result;
    }

    public static UserAccountDAO getUserAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        UserAccountDAO result = (UserAccountDAO) ci.getDAO(UserAccount.class);
        return result;
    }

    public static VoteDAO getVoteDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VoteDAO result = (VoteDAO) ci.getDAO(Vote.class);
        return result;
    }

    public static VoteCountingDAO getVoteCountingDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VoteCountingDAO result = (VoteCountingDAO) ci.getDAO(VoteCounting.class);
        return result;
    }

    public static VoteToChoiceDAO getVoteToChoiceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VoteToChoiceDAO result = (VoteToChoiceDAO) ci.getDAO(VoteToChoice.class);
        return result;
    }

    public static VotingListDAO getVotingListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VotingListDAO result = (VotingListDAO) ci.getDAO(VotingList.class);
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollenModelEntityEnum constant = PollenModelEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollenModelEntityEnum constant = PollenModelEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        PollenModelEntityEnum constant = PollenModelEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    @SuppressWarnings({"unchecked"})
    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        PollenModelEntityEnum constant = PollenModelEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getContractClasses() {
        PollenModelEntityEnum[] values = PollenModelEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    @SuppressWarnings({"unchecked"})
    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        PollenModelEntityEnum[] values = PollenModelEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static PollenModelEntityEnum[] getContracts() {
        return PollenModelEntityEnum.values();
    }

    /*
     * Enumeration of all types of entities managed by this helper.
     */
    public enum PollenModelEntityEnum implements org.nuiton.topia.persistence.TopiaEntityEnum {

        Choice(Choice.class),
        ChoiceType(ChoiceType.class),
        Comment(Comment.class),
        PersonList(PersonList.class),
        PersonToList(PersonToList.class),
        Poll(Poll.class),
        PollAccount(PollAccount.class),
        PollType(PollType.class),
        PreventRule(PreventRule.class),
        Result(Result.class),
        UserAccount(UserAccount.class),
        Vote(Vote.class),
        VoteCounting(VoteCounting.class),
        VoteToChoice(VoteToChoice.class),
        VotingList(VotingList.class);

        /** the contract of the entity */
        private Class<? extends TopiaEntity> contract;

        /** the fully qualified name of the implementation of the entity */
        private String implementationFQN;

        /** the implementation class of the entity (will be lazy computed at runtime)*/
        private Class<? extends TopiaEntity> implementation;

        PollenModelEntityEnum(Class<? extends TopiaEntity > contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName()+"Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract() {
            return contract;
        }
       
        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return getContract();
        }
        
        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return getImplementation();
        }

        @Override
        public String getImplementationFQN() {
            return implementationFQN;
        }

        @Override
        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass) {
            return PollenModelDAOHelper.getContractClass(klass) == contract;
        }
 
        @Override
        @SuppressWarnings({"unchecked"})
        public Class<? extends TopiaEntity> getImplementation() {
            if (implementation == null) {
                try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
            }
            return implementation;
        }

        public static PollenModelEntityEnum valueOf(TopiaEntity entity) {
            return valueOf(entity.getClass());
        }

        public static PollenModelEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return PollenModelEntityEnum.valueOf(klass.getSimpleName());
            }
            for (PollenModelEntityEnum entityEnum : PollenModelEntityEnum.values()) {
                if (entityEnum.getContract().isAssignableFrom(klass)) {
                    //todo check it works for inheritance
                    return entityEnum;
                }
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(PollenModelEntityEnum.values()));
        }        
    }

    /**
     * use {@link #getImplementationClassesAsString()}
     *
     * @deprecated (will be removed soon).
     */
    public static final String entitiesList = "" +
        "org.chorem.pollen.business.persistence.ChoiceImpl," +
        "org.chorem.pollen.business.persistence.ChoiceTypeImpl," +
        "org.chorem.pollen.business.persistence.CommentImpl," +
        "org.chorem.pollen.business.persistence.PersonListImpl," +
        "org.chorem.pollen.business.persistence.PersonToListImpl," +
        "org.chorem.pollen.business.persistence.PollImpl," +
        "org.chorem.pollen.business.persistence.PollAccountImpl," +
        "org.chorem.pollen.business.persistence.PollTypeImpl," +
        "org.chorem.pollen.business.persistence.PreventRuleImpl," +
        "org.chorem.pollen.business.persistence.ResultImpl," +
        "org.chorem.pollen.business.persistence.UserAccountImpl," +
        "org.chorem.pollen.business.persistence.VoteImpl," +
        "org.chorem.pollen.business.persistence.VoteCountingImpl," +
        "org.chorem.pollen.business.persistence.VoteToChoiceImpl," +
        "org.chorem.pollen.business.persistence.VotingListImpl";

} //PollenModelDAOHelper
