/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;

import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.VoteDTO;

/**
 * Interface du service de vote.
 *
 * @version $Id: ServiceVote.java 2912 2010-03-09 16:44:39Z fdesbois $
 */
public interface ServiceVote {

    /**
     * Rajouter un vote à un sondage
     *
     * @param voteDTO Le DTO du vote
     * @return L'ID du vote créé
     */
    public String createVote(VoteDTO voteDTO, PollAccountDTO pollAccountDTO);

    /**
     * Mise à jour d'un vote
     *
     * @param voteDTO Le DTO du vote
     * @return Retourne TRUE si la mise à jour s'est correctement déroulée
     */
    public boolean updateVote(VoteDTO voteDTO);

    /**
     * Supprime un vote de la base de données
     *
     * @param voteId L'identifiant du vote
     * @return Retourne TRUE si la suppression s'est correctement déroulée
     */
    public boolean deleteVote(String voteId);

    /**
     * Retrieve existings votes from the {@code poll}. Only needed votes inside
     * the range ({@code startIndex} and {@code endIndex}) will be retrieve.
     * The results will be ordered by creationDate (the last vote done will
     * be at the end of the list).
     *
     * @param poll to retrieve votes
     * @param startIndex begin range for resulting votes
     * @param endIndex end range for resulting votes
     * @return the votes corresponding to the poll between the range
     */
    public List<VoteDTO> getVotesByPoll(PollDTO poll,
            int startIndex, int endIndex);

    /**
     * Test if the {@code votingId} has already voted for the {@code poll}.
     * 
     * @param votingId to test existing vote
     * @param poll where the votingId can have already voted
     * @return true if the votingId has already voted or false otherwise
     */
    public boolean hasAlreadyVoted(String votingId, PollDTO poll);

    /**
     * Retourne les votes d'un sondage
     *
     * @param properties La HashMap pour sélectionner les votes d'un sondage. Il
     *            faut y mettre le bon champs pollId
     * @return Les votes d'un sondage dans un DTO, le tout stocké dans une
     *         liste.
     */
    public List<VoteDTO> selectVotes(Map<String, Object> properties);

}
