/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={"name"},
  numFields={"weight"}
)        
public interface VotingList extends TopiaEntity {

    public static final String NAME = "name";

    public static final String WEIGHT = "weight";

    public static final String POLL_ACCOUNT_PERSON_TO_LIST = "pollAccountPersonToList";

    public static final String POLL = "poll";

    public static final String VOTE = "vote";

    /**
     * @param name La valeur de l'attribut name à positionner.
     */
    public void setName(java.lang.String name);

    /**
     * @return La valeur de l'attribut name.
     */
    public java.lang.String getName();

    /**
     * @param weight La valeur de l'attribut weight à positionner.
     */
    public void setWeight(java.lang.Double weight);

    /**
     * @return La valeur de l'attribut weight.
     */
    public java.lang.Double getWeight();

    /**
     * @param personToList L'instance de PersonToList à ajouter.
     */
    public void addPollAccountPersonToList(org.chorem.pollen.business.persistence.PersonToList personToList);

    /**
     * @param personToList Les instances de PersonToList à ajouter.
     */
    public void addAllPollAccountPersonToList(java.util.List<org.chorem.pollen.business.persistence.PersonToList> personToList);

    /**
     * @param personToList La Collection de PersonToList à positionner.
     */
    public void setPollAccountPersonToList(java.util.List<org.chorem.pollen.business.persistence.PersonToList> personToList);

    /**
     * @param personToList L'instance de PersonToList à retirer.
     */
    public void removePollAccountPersonToList(org.chorem.pollen.business.persistence.PersonToList personToList);

    /**
     * Vide la Collection de PersonToList.
     */
    public void clearPollAccountPersonToList();

    /**
     * @return La liste des attributs PersonToList.
     */
    public java.util.List<org.chorem.pollen.business.persistence.PersonToList> getPollAccountPersonToList();

    /**
     * Recupère l'attribut pollAccount à partir de son topiaId.
     *
     * @param topiaId le topia id de l'attribut recherchée
     * 
     * @return l'attribut recherché, ou <code>null</code> s'il n'existe pas.
     */
    public org.chorem.pollen.business.persistence.PersonToList getPollAccountPersonToListByTopiaId(String topiaId);

    /**
     * @return L'attribut PersonToList associé à la valeur <code>value</code> de l'attribut pollAccount.
     */
    public org.chorem.pollen.business.persistence.PersonToList getPollAccountPersonToList(org.chorem.pollen.business.persistence.PollAccount value);

    /**
     * @return Le nombre d'éléments de la collection pollAccount.
     */
    public int sizePollAccountPersonToList();
  
    /**
     * @return <code>true</code> si la collection pollAccountPersonToList est vide.
     */
    public boolean isPollAccountPersonToListEmpty();
    /**
     * @param poll La valeur de l'attribut poll à positionner.
     */
    public void setPoll(org.chorem.pollen.business.persistence.Poll poll);

    /**
     * @return La valeur de l'attribut poll.
     */
    public org.chorem.pollen.business.persistence.Poll getPoll();

    /**
     * @param vote La valeur de l'attribut vote à positionner.
     */
    public void setVote(org.chorem.pollen.business.persistence.Vote vote);

    /**
     * @return La valeur de l'attribut vote.
     */
    public org.chorem.pollen.business.persistence.Vote getVote();

} //VotingList
