/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité VoteToChoice.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class VoteToChoiceDAOAbstract<E extends VoteToChoice> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)VoteToChoice.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut voteValue
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * voteValue le paramètre
     * @param v la valeur que doit avoir voteValue
     * @return un element ou null
     */
    public E findByVoteValue(java.lang.Integer v) throws TopiaException {
        E result = findByProperty("voteValue", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * voteValue le paramètre
     * @param v la valeur que doit avoir voteValue
     * @return une liste
     */
    public List<E> findAllByVoteValue(java.lang.Integer v) throws TopiaException {
        List<E> result = findAllByProperty("voteValue", v);
        return result;
    }
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return un element ou null
     */
    public E findContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        E result = findContainsProperties("vote", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * vote contient le paramètre
     * @param v la valeur que doit contenir vote
     * @return une liste
     */
    public List<E> findAllContainsVote(org.chorem.pollen.business.persistence.Vote ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("vote", Arrays.asList(v));
        return results;
    }
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return un element ou null
     */
    public E findContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        E result = findContainsProperties("choice", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * choice contient le paramètre
     * @param v la valeur que doit contenir choice
     * @return une liste
     */
    public List<E> findAllContainsChoice(org.chorem.pollen.business.persistence.Choice ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("choice", Arrays.asList(v));
        return results;
    }

} // VoteToChoiceDAOAbstract
