/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;

import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.VoteCountingType;

/**
 * Classe DTO représentant un résultat de sondage.
 *
 * @author amine
 * @author rannou
 * @version $Id: ResultDTO.java 2859 2010-02-09 13:50:24Z jruchaud $
 */
public class ResultDTO implements Serializable {

    private String id = "";

    private String name = "";

    private String value = "";

    private String pollId = "";

    private ChoiceType choiceType;

    private VoteCountingType voteCounting;

    private boolean byGroup = false;

    private boolean hidden = false;

    public ResultDTO() {

    }

    public ResultDTO(String id) {
        this.id = id;
    }

    public ResultDTO(String name, String pollId, ChoiceType choiceType,
            VoteCountingType myVoteCounting) {
        super();
        this.name = name;
        this.pollId = pollId;
        this.choiceType = choiceType;
        this.voteCounting = myVoteCounting;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public ChoiceType getChoiceType() {
        return choiceType;
    }

    public void setChoiceType(ChoiceType choiceType) {
        this.choiceType = choiceType;
    }

    public VoteCountingType getVoteCounting() {
        return voteCounting;
    }

    public void setVoteCounting(VoteCountingType voteCounting) {
        this.voteCounting = voteCounting;
    }

    public boolean isByGroup() {
        return byGroup;
    }

    public void setByGroup(boolean byGroup) {
        this.byGroup = byGroup;
    }

    public boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}