/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Classe DTO représentant une liste de personnes.
 *
 * @author amine
 * @author rannou
 * @version $Id: PersonListDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PersonListDTO implements Serializable {

    private String id = "";

    private String userId = "";

    private String name = "";

    private List<PollAccountDTO> pollAccountDTOs = new ArrayList<PollAccountDTO>();

    public PersonListDTO() {

    }

    public PersonListDTO(String id) {
        this.id = id;
    }

    public PersonListDTO(String name, String userId) {
        super();
        this.name = name;
        this.userId = userId;

    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<PollAccountDTO> getPollAccountDTOs() {
        return pollAccountDTOs;
    }

    public void setPollAccountDTOs(List<PollAccountDTO> pollAccountDTOs) {
        this.pollAccountDTOs = pollAccountDTOs;
    }

}
