/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Classe DTO représentant un commentaire.
 *
 * @author amine
 * @author rannou
 * @version $Id: CommentDTO.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class CommentDTO implements Serializable {

    private String id = "";

    private String text = "";

    private Date postDate = null;

    private String pollId = "";

    private String pollAccountId = "";

    public CommentDTO() {

    }

    public CommentDTO(String id) {
        this.id = id;
    }

    public CommentDTO(String text, String pollId, String pollAccountId) {
        super();
        this.text = text;
        this.pollId = pollId;
        this.pollAccountId = pollAccountId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getPostDate() {
        return postDate;
    }

    public void setPostDate(Date postDate) {
        this.postDate = postDate;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String getPollAccountId() {
        return pollAccountId;
    }

    public void setPollAccountId(String pollAccountId) {
        this.pollAccountId = pollAccountId;
    }

}