/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.converters;

import org.chorem.pollen.business.persistence.ChoiceTypeDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollTypeDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.VoteCountingDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * Classe de gestion des énumérations.
 *
 * @author fdesbois
 * @version $Id: EnumController.java 2731 2009-08-18 12:22:46Z nrannou $
 */
public class EnumController extends DataConverter {

    public EnumController(TopiaContext transaction) {
        super(transaction);
    }

    public void setChoiceType(ChoiceType type, Poll ePoll) {
        try {
            if (type != null) {
                ChoiceTypeDAO dao = PollenModelDAOHelper
                        .getChoiceTypeDAO(transaction);
                ePoll.setChoiceType(dao.findByName(type.name()));
            }
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
        }
    }

    public void setPollType(PollType type, Poll ePoll) {
        try {
            if (type != null) {
                PollTypeDAO dao = PollenModelDAOHelper
                        .getPollTypeDAO(transaction);
                ePoll.setPollType(dao.findByName(type.name()));
            }
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
        }
    }

    public void setVoteCounting(VoteCountingType type, Poll ePoll) {
        try {
            if (type != null) {
                VoteCountingDAO dao = PollenModelDAOHelper
                        .getVoteCountingDAO(transaction);
                ePoll.setVoteCounting(dao.findByName(type.name()));
            }
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
        }
    }

    public void setVoteCounting(VoteCountingType type, Result eResult) {
        try {
            if (type != null) {
                VoteCountingDAO dao = PollenModelDAOHelper
                        .getVoteCountingDAO(transaction);
                eResult.setVoteCounting(dao.findByName(type.name()));
            }
        } catch (TopiaException e) {
            ContextUtil.doCatch(e, transaction);
        }
    }

    public static ChoiceType getChoiceType(String type) {
        return ChoiceType.valueOf(type);
    }

    public static ChoiceType getChoiceType(Poll poll) {
        if (poll.getChoiceType() == null) {
            return null;
        }
        return getChoiceType(poll.getChoiceType().getName());
    }

    public static VoteCountingType getVoteCountingType(String type) {
        return VoteCountingType.valueOf(type);
    }

    public static VoteCountingType getVoteCountingType(Poll poll) {
        if (poll.getVoteCounting() == null) {
            return null;
        }
        return getVoteCountingType(poll.getVoteCounting().getName());
    }

    public static VoteCountingType getVoteCountingType(Result result) {
        if (result.getVoteCounting() == null) {
            return null;
        }
        return getVoteCountingType(result.getVoteCounting().getName());
    }

    public static PollType getPollType(String type) {
        return PollType.valueOf(type);
    }

    public static PollType getPollType(Poll poll) {
        if (poll.getPollType() == null) {
            return null;
        }
        return getPollType(poll.getPollType().getName());
    }

    public static boolean isGroupType(Poll poll) {
        return "GROUP".equals(poll.getPollType().getName());
    }

}
