/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Classe DTO représentant un vote.
 *
 * @author amine
 * @author rannou
 * @version $Id: VoteDTO.java 2732 2009-08-18 12:26:50Z nrannou $
 */
public class VoteDTO implements Serializable {

    private String id = "";

    private double weight = 0;

    private String comment = "";

    private boolean anonymous = false;

    private String pollAccountId = "";

    private String pollId = "";

    private String votingListId = "";

    private List<ChoiceDTO> choiceDTOs = new ArrayList<ChoiceDTO>();

    public VoteDTO() {
    }

    public VoteDTO(String id) {
        this.id = id;
    }

    public VoteDTO(String pollAccountId, String pollId, String votingListId) {
        this.pollAccountId = pollAccountId;
        this.pollId = pollId;
        this.votingListId = votingListId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getWeight() {
        return weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isAnonymous() {
        return anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getPollAccountId() {
        return pollAccountId;
    }

    public void setPollAccountId(String pollAccountId) {
        this.pollAccountId = pollAccountId;
    }

    public String getPollId() {
        return pollId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public String getVotingListId() {
        return votingListId;
    }

    public void setVotingListId(String votingListId) {
        this.votingListId = votingListId;
    }

    public List<ChoiceDTO> getChoiceDTOs() {
        return choiceDTOs;
    }

    public void setChoiceDTOs(List<ChoiceDTO> choiceDTOs) {
        this.choiceDTOs = choiceDTOs;
    }

}