/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.utils;

import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.ChoiceTypeDAO;
import org.chorem.pollen.business.persistence.PollTypeDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.VoteCountingDAO;
import org.chorem.pollen.business.utils.PropertiesLoader;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaDAO;

public class ContextUtil {
    private static ContextUtil instance = null;
    private TopiaContext context = null;
    private TopiaContext transaction = null;
    private Properties conf = PropertiesLoader.loadPropertiesFile("pollen.properties");
    private static final Log log = LogFactory.getLog(ContextUtil.class);

    public TopiaContext getContext() {
        return this.context;
    }

    public void buildContext() {
        if (this.context == null || this.context.isClosed()) {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Construction du contexte global...");
                }
                this.context = TopiaContextFactory.getContext((Properties)this.conf);
            }
            catch (TopiaNotFoundException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Erreur lors de la construction du contexte");
                }
                e.printStackTrace();
            }
        }
    }

    public static ContextUtil getInstance() {
        if (instance == null) {
            instance = new ContextUtil();
        }
        return instance;
    }

    private ContextUtil() {
        this.conf.setProperty("topia.persistence.classes", PollenModelDAOHelper.getImplementationClassesAsString());
        this.buildContext();
        this.initDB();
    }

    protected void initDB() {
        try {
            this.transaction = this.context.beginTransaction();
            ChoiceTypeDAO choiceTypeDAO = PollenModelDAOHelper.getChoiceTypeDAO(this.transaction);
            this.loadDB("choiceType", choiceTypeDAO);
            PollTypeDAO pollTypeDAO = PollenModelDAOHelper.getPollTypeDAO(this.transaction);
            this.loadDB("pollType", pollTypeDAO);
            VoteCountingDAO voteCountingDAO = PollenModelDAOHelper.getVoteCountingDAO(this.transaction);
            this.loadDB("voteCounting", voteCountingDAO);
            this.transaction.closeContext();
        }
        catch (TopiaException e) {
            this.doCatch(e);
        }
    }

    private void loadDB(String element, TopiaDAO dao) throws TopiaException {
        List types = dao.findAll();
        if (types.size() == 0) {
            String strType = this.conf.getProperty(element);
            String[] tabTypes = strType.split(",");
            for (int i = 0; i < tabTypes.length; ++i) {
                dao.create(new Object[]{"name", tabTypes[i]});
            }
        }
        this.transaction.commitTransaction();
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

