/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.DatabaseManager;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.util.VersionUtil;

public class PollenMigrationCallbackHandler
implements MigrationCallbackHandler {
    private static final Log log = LogFactory.getLog(PollenMigrationCallbackHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationCallbackHandler.MigrationChoice doMigration(DatabaseManager dbManager, String dbVersion, String applicationVersion) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Migration : version de la base : " + dbVersion + ", version de l'application : " + applicationVersion));
        }
        MigrationCallbackHandler.MigrationChoice result = MigrationCallbackHandler.MigrationChoice.NO_MIGRATION;
        try {
            Connection conn = dbManager.getConnection();
            try {
                conn.setAutoCommit(false);
                if (VersionUtil.valueOf((String)dbVersion).compareTo(VersionUtil.valueOf((String)"1.0")) < 0) {
                    // empty if block
                }
                conn.commit();
                result = MigrationCallbackHandler.MigrationChoice.CUSTOM_MIGRATION;
            }
            catch (Exception eee) {
                log.error((Object)"Migration impossible de la base", (Throwable)eee);
                conn.rollback();
            }
            finally {
                conn.close();
            }
        }
        catch (Exception eee) {
            log.error((Object)"Erreur lors de la tentative de migration", (Throwable)eee);
        }
        return result;
    }

    private void migrateTo1_0_test(Connection conn) throws SQLException {
        String[] sqls;
        log.info((Object)"Migrate to version 1_0_test");
        for (String sql : sqls = new String[]{"drop table listtype cascade;", "drop table poll_preventrule;", "alter table \"user\" rename to useraccount;", "alter table pollaccount rename \"user\" to useraccount;", "alter table poll drop column sendemailtouser;", "alter table votetochoice rename value to votevalue;", "alter table result rename value to resultvalue;", "alter table result rename isbygroup to bygroup;", "alter table useraccount rename isadministrator to administrator;", "alter table choice rename isvalidate to validate;", "alter table poll rename isanonymous to anonymous;", "alter table poll rename isanonymousvoteallowed to anonymousvoteallowed;", "alter table poll rename ischoiceaddallowed to choiceaddallowed;", "alter table poll rename isclosed to closed;", "alter table comment add postdate timestamp;", "alter table preventrule add scope varchar;", "alter table preventrule add repeated boolean;", "alter table poll add publicresults boolean default false;", "alter table poll add continuousresults boolean default false;", "alter table preventrule add poll varchar(255);", "alter table preventrule add constraint fk_migration_preventrule foreign key(poll) references poll(topiaid);"}) {
            log.info((Object)("try " + sql));
            PreparedStatement sta = conn.prepareStatement(sql);
            sta.executeUpdate();
            log.info((Object)("done " + sql));
        }
    }
}

