/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.chorem.lima.service.neogia;

import org.chorem.lima.service.CompanyService;
import org.chorem.lima.service.StatusService;
import org.chorem.lima.service.TransactionService;
import org.chorem.lima.service.AccountService;
import org.chorem.lima.service.EntryService;
import org.chorem.lima.service.FileService;
import org.chorem.lima.service.UserService;
import org.chorem.lima.service.PeriodService;
import org.chorem.lima.service.ServiceFactory;
import org.chorem.lima.service.JournalService;
import java.util.Map;

/** @author ore */
public class NeogiaServiceFactory extends ServiceFactory {

    @Override
    protected void initFactory(Map<String, Object> properties) {
        //do init of factory
    }

    @Override
    public AccountService getAccountService() {
        return new NeogiaAccountService();
    }

    @Override
    public JournalService getJournalService() {
        return new NeogiaJournalService();
    }

    @Override
    public TransactionService getTransactionService() {
        return new NeogiaTransactionService();
    }

    @Override
    public EntryService getEntryService() {
        return new NeogiaEntryService();
    }

    @Override
    public PeriodService getPeriodService() {
        return new NeogiaPeriodService();
    }

    @Override
    public CompanyService getCompanyService() {
        return new NeogiaCompanyService();
    }

    @Override
    public UserService getUserService() {
        return new NeogiaUserService();
    }

    @Override
    public StatusService getStatusService() {
        return new NeogiaStatusService();
    }

    @Override
    public FileService getFileService() {
        return new NeogiaFileService();
    }
}
