/**
 * *##% Lima Neogia service
 * Copyright (C) 2008 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
/**
 * # #% Copyright (C) 2008 Code Lutin, Tony Chemit 
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * # #%
 */
package org.chorem.lima.service.neogia;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.chorem.lima.dto.EntryDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.dto.TransactionDTO;
import org.chorem.lima.dto.util.DTOHelper;
import org.chorem.lima.service.EntryService;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.chorem.lima.service.util.ServiceHelper;
import org.ofbiz.webservice.proxies.*;
import org.ofbiz.webservice.proxies.AddEntryDocument.AddEntry;
import org.ofbiz.webservice.proxies.RemoveEntryDocument.RemoveEntry;
import org.ofbiz.webservice.proxies.UpdateEntryDocument.UpdateEntry;
import org.ofbiz.webservice.wrappers.xsd.AddEntryResult;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlEntry;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlEntryAndGlEntryAccount;

import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;

/**
 * @author chemit
 */
public class NeogiaEntryService implements EntryService {

    /**
     * log
     */
    protected static final Log log = LogFactory.getLog(NeogiaEntryService.class);
    private final String DEBIT = "DEBIT";
    private final String CREDIT = "CREDIT";

    @Override
    public List<EntryDTO> getAllEntry() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<EntryDTO> getEntryByTransaction(TransactionDTO trans, List<AccountDTO> accounts) {
        List<EntryDTO> list = new LinkedList<EntryDTO>();
        try {
            GetEntryByTransactionStub stub = new GetEntryByTransactionStub();
            GetEntryByTransactionDocument document = GetEntryByTransactionDocument.Factory.newInstance();
            GetEntryByTransactionDocument.GetEntryByTransaction element = GetEntryByTransactionDocument.GetEntryByTransaction.Factory.newInstance();
            element.setIdSeq(trans.getIdSeq());
            element.setIdName(trans.getIdName());
            document.setGetEntryByTransaction(element);
            GetEntryByTransactionResponseDocument response = stub.getEntryByTransaction(document);
            GenericValueGlEntryAndGlEntryAccount[] array = response.getGetEntryByTransactionResponse().getReturnArray();
            for (GenericValueGlEntryAndGlEntryAccount value : array) {
                EntryDTO entry = NeogiaUtil.mapToEntryDTO(value, accounts);
                list.add(entry);
            }
        } catch (RemoteException e) {
            log.error(e);
        }
        return list;
    }

    @Override
    public String removeEntry(List<StatusDTO> list, EntryDTO entry) {
        if (log.isDebugEnabled()) {
            log.debug("removeEntry : ");
        }
        try {
            RemoveEntryStub stub = new RemoveEntryStub();
            RemoveEntryDocument document = RemoveEntryDocument.Factory.newInstance();
            RemoveEntry element = RemoveEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setSequenceId(Long.parseLong(entry.getIdSeq()));
            document.setRemoveEntry(element);
            RemoveEntryResponseDocument response = stub.removeEntry(document);
            if (list != null) {
                String status = response.getRemoveEntryResponse().getReturn();
                entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, status));
            }

            if (log.isDebugEnabled()) {
                log.debug("entry " + entry.getDescription() + " removed");
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String updateEntry(List<StatusDTO> list, EntryDTO entry) {
        try {
            UpdateEntryStub stub = new UpdateEntryStub();
            UpdateEntryDocument document = UpdateEntryDocument.Factory.newInstance();
            UpdateEntry element = UpdateEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setSequenceId(Long.parseLong(entry.getIdSeq()));
            element.setAmount(DTOHelper.parse(entry.getAmount()));
            if (DTOHelper.hasAccount(entry)) {
                element.setAccountAccount(entry.getAccount().getIdNumber());
            }
            if (!DTOHelper.isEmpty(entry.getDescription())) {
                element.setDescription(entry.getDescription());
            }

            element.setDebitCreditEnumId(DTOHelper.isCredit(entry) ? CREDIT : DEBIT);
            document.setUpdateEntry(element);

            UpdateEntryResponseDocument response = stub.updateEntry(document);
            if (list != null) {
                String status = response.getUpdateEntryResponse().getReturn();
                entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, status));
            }
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }

    @Override
    public String addEntry(List<StatusDTO> list, EntryDTO entry) {
        try {
            AddEntryStub stub = new AddEntryStub();
            AddEntryDocument document = AddEntryDocument.Factory.newInstance();
            AddEntry element = AddEntry.Factory.newInstance();
            element.setTrItAtranIdName(entry.getTransaction().getIdName());
            element.setTrItSequenceId(entry.getTransaction().getIdSeq());
            element.setAmount(DTOHelper.parse(entry.getAmount()));
            element.setDebitCreditEnumId(DTOHelper.isCredit(entry) ? CREDIT : DEBIT);

            if (DTOHelper.hasAccount(entry)) {
                element.setAccountAccount(entry.getAccount().getIdNumber());
            }
            if (!DTOHelper.isEmpty(entry.getDescription())) {
                element.setDescription(entry.getDescription());
            }
            document.setAddEntry(element);
            AddEntryResponseDocument response = stub.addEntry(document);
            AddEntryResult result = response.getAddEntryResponse().getReturn();
            GenericValueGlEntry value = result.getValue();
            String status = result.getStatus();
            entry.setIdSeq(Long.toString(value.getSequenceId()));
            entry.getTransaction().setStatus(ServiceHelper.findStatusById(list, status));
            return ServiceHelper.RESPOND_SUCCESS;
        } catch (RemoteException ex) {
            log.error(ex);
            return ServiceHelper.RESPOND_ERROR;
        }
    }
}
