/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.cache2k.Cache;
import org.cache2k.CacheClosedException;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.EntryProcessingResultFactory;
import org.cache2k.core.api.InternalCache;
import org.cache2k.core.api.InternalCacheInfo;
import org.cache2k.core.common.BaseCacheControl;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.operation.CacheControl;
import org.cache2k.operation.CacheInfo;
import org.cache2k.operation.CacheOperation;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class BaseCache<K, V>
implements InternalCache<K, V> {
    public abstract Executor getExecutor();

    protected abstract <R> EntryAction<K, V, R> createFireAndForgetAction(Entry<K, V> var1, Semantic<K, V, R> var2);

    private static String nameQualifier(Cache<?, ?> cache) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'').append(cache.getName()).append('\'');
        if (!cache.getCacheManager().isDefaultManager()) {
            sb.append(", manager='").append(cache.getCacheManager().getName()).append('\'');
        }
        return sb.toString();
    }

    @Override
    public String getQualifiedName() {
        return BaseCache.nameQualifier(this);
    }

    protected abstract Iterator<CacheEntry<K, V>> iterator();

    public Set<K> keys() {
        return this.asMap().keySet();
    }

    public Set<CacheEntry<K, V>> entries() {
        return new AbstractSet<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return BaseCache.this.iterator();
            }

            @Override
            public int size() {
                return (int)BaseCache.this.getTotalEntryCount();
            }
        };
    }

    public void removeAll() {
        this.removeAll(this.keys());
    }

    public void removeAll(Iterable<? extends K> keys) {
        for (K k : keys) {
            this.remove(k);
        }
    }

    public <X> X requestInterface(Class<X> type) {
        if (type.equals(ConcurrentMap.class) || type.equals(Map.class)) {
            return (X)this.asMap();
        }
        if (type.isAssignableFrom(CacheOperation.class) || type.isAssignableFrom(CacheInfo.class) || type.isAssignableFrom(CacheControl.class)) {
            return (X)new BaseCacheControl(this);
        }
        if (type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        throw new UnsupportedOperationException();
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    public <R> R invoke(K key, EntryProcessor<K, V, R> processor) {
        if (key == null || processor == null) {
            throw new NullPointerException();
        }
        return this.execute(key, Operations.SINGLETON.invoke(processor));
    }

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap m = new HashMap();
        for (K k : keys) {
            try {
                R result = this.invoke(k, entryProcessor);
                if (result == null) continue;
                m.put(k, EntryProcessingResultFactory.result(result));
            }
            catch (Throwable t) {
                m.put(k, EntryProcessingResultFactory.exception(t));
            }
        }
        return Collections.unmodifiableMap(m);
    }

    public void expireAt(K key, long time) {
        this.execute(key, Operations.SINGLETON.expire(key, time));
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> action = this.createEntryAction(key, e, op);
        action.start();
        RuntimeException t = action.getExceptionToPropagate();
        if (t != null) {
            throw t;
        }
        return (R)action.getResult();
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    @Override
    public void closeCustomization(Object customization, String customizationName) {
        if (customization instanceof AutoCloseable) {
            try {
                ((AutoCloseable)customization).close();
            }
            catch (Exception e) {
                String message = customizationName + ".close() exception (" + BaseCache.nameQualifier(this) + ")";
                throw new CacheException(message, (Throwable)e);
            }
        }
    }

    public String toString() {
        try {
            InternalCacheInfo fo = this.getConsistentInfo();
            return fo.toString();
        }
        catch (CacheClosedException ex) {
            return "Cache(name=" + BaseCache.nameQualifier(this) + ", closed=true)";
        }
    }
}

