/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class USERID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sLanguage = null;
    private String m_sTermsOfUse = null;

    public USERID3V2Frame(String sLanguage, String sTermsOfUse) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("Language must be a three character length string in USER frame.");
        }
        this.m_sLanguage = sLanguage;
        if (sTermsOfUse == null || sTermsOfUse.length() == 0) {
            throw new ID3Exception("Terms of use are required in USER frame.");
        }
        this.m_sTermsOfUse = sTermsOfUse;
    }

    public USERID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            byte[] abyLanguage = new byte[3];
            oFrameDataID3DIS.readFully(abyLanguage);
            this.m_sLanguage = new String(abyLanguage);
            byte[] abyTermsOfUse = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyTermsOfUse);
            this.m_sTermsOfUse = new String(abyTermsOfUse, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitUSERID3V2Frame(this);
    }

    public void setTermsOfUse(String sLanguage, String sTermsOfUse) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("Language must be a three character length string in USER frame.");
        }
        this.m_sLanguage = sLanguage;
        if (sTermsOfUse == null || sTermsOfUse.length() == 0) {
            throw new ID3Exception("Terms of use are required in USER frame.");
        }
        this.m_sTermsOfUse = sTermsOfUse;
    }

    public String getLanguage() {
        return this.m_sLanguage;
    }

    public String getTermsOfUse() {
        return this.m_sTermsOfUse;
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "USER".getBytes();
    }

    public String toString() {
        return "Terms of use: Language=[" + this.m_sLanguage + "], Terms of use=[" + this.m_sTermsOfUse + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sLanguage.getBytes());
        oIDOS.write(this.m_sTermsOfUse.getBytes(this.m_oTextEncoding.getEncodingString()));
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof USERID3V2Frame)) {
            return false;
        }
        USERID3V2Frame oOtherUSER = (USERID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherUSER.m_oTextEncoding) && this.m_sLanguage.equals(oOtherUSER.m_sLanguage) && this.m_sTermsOfUse.equals(oOtherUSER.m_sTermsOfUse);
    }
}

