/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class UFIDID3V2Frame
extends ID3V2Frame {
    private String m_sOwnerIdentifier = null;
    private byte[] m_abyIdentifier = null;

    public UFIDID3V2Frame(String sOwnerIdentifier, byte[] abyIdentifier) throws ID3Exception {
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("The owner identifier cannot be null or zero length in UFID frame.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        if (abyIdentifier == null || abyIdentifier.length > 64) {
            throw new ID3Exception("The identifier be a non-null byte array of length 0-64 bytes in UFID frame.");
        }
        this.m_abyIdentifier = abyIdentifier;
    }

    public UFIDID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_sOwnerIdentifier = oFrameDataID3DIS.readStringToNull();
            this.m_abyIdentifier = new byte[oFrameDataID3DIS.available()];
            if (oFrameDataID3DIS.available() > 0) {
                oFrameDataID3DIS.readFully(this.m_abyIdentifier);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitUFIDID3V2Frame(this);
    }

    public void setUniqueIdentifier(String sOwnerIdentifier, byte[] abyIdentifier) throws ID3Exception {
        String sOrigOwnerIdentifier = this.m_sOwnerIdentifier;
        byte[] abyOrigIdentifier = this.m_abyIdentifier;
        if (sOwnerIdentifier == null || sOwnerIdentifier.length() == 0) {
            throw new ID3Exception("The owner identifier cannot be null or zero length in UFID frame.");
        }
        if (abyIdentifier == null || abyIdentifier.length > 64) {
            throw new ID3Exception("The identifier must be a non-null byte array of length 0-64 bytes in UFID frame.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        this.m_abyIdentifier = abyIdentifier;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sOwnerIdentifier = sOrigOwnerIdentifier;
            this.m_abyIdentifier = abyOrigIdentifier;
            throw e;
        }
    }

    public String getOwnerIdentifier() {
        return this.m_sOwnerIdentifier;
    }

    public byte[] getIdentifier() {
        return this.m_abyIdentifier;
    }

    protected byte[] getFrameId() {
        return "UFID".getBytes();
    }

    public String toString() {
        return "Unique file identifier: Owner identifier=[" + this.m_sOwnerIdentifier + "], Identifier length=[" + this.m_abyIdentifier.length + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sOwnerIdentifier.getBytes());
        oIDOS.write(0);
        oIDOS.write(this.m_abyIdentifier);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof UFIDID3V2Frame)) {
            return false;
        }
        UFIDID3V2Frame oOtherUFID = (UFIDID3V2Frame)oOther;
        return this.m_sOwnerIdentifier.equals(oOtherUFID.m_sOwnerIdentifier) && Arrays.equals(this.m_abyIdentifier, oOtherUFID.m_abyIdentifier);
    }
}

