/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TSIZTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iSizeInBytes;

    public TSIZTextInformationID3V2Frame(int iSizeInBytes) throws ID3Exception {
        super(Integer.toString(iSizeInBytes));
        if (iSizeInBytes < 0) {
            throw new ID3Exception("Size value cannot be negative.");
        }
        this.m_iSizeInBytes = iSizeInBytes;
    }

    public TSIZTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iSizeInBytes = Integer.parseInt(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TSIZ file size frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTSIZTextInformationID3V2Frame(this);
    }

    public void setSizeInBytes(int iSizeInBytes) throws ID3Exception {
        if (iSizeInBytes < 0) {
            throw new ID3Exception("Size value cannot be negative.");
        }
        this.m_iSizeInBytes = iSizeInBytes;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iSizeInBytes);
    }

    public int getSizeInBytes() {
        return this.m_iSizeInBytes;
    }

    protected byte[] getFrameId() {
        return "TSIZ".getBytes();
    }

    public String toString() {
        return "Size (in bytes excluding tags): [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TSIZTextInformationID3V2Frame)) {
            return false;
        }
        TSIZTextInformationID3V2Frame oOtherTSIZ = (TSIZTextInformationID3V2Frame)oOther;
        return this.m_iSizeInBytes == oOtherTSIZ.m_iSizeInBytes && this.m_oTextEncoding.equals(oOtherTSIZ.m_oTextEncoding) && this.m_sInformation.equals(oOtherTSIZ.m_sInformation);
    }
}

