/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TRCKTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iTrackNumber;
    private int m_iTotalTracks;

    public TRCKTextInformationID3V2Frame(int iTrackNumber) throws ID3Exception {
        super(Integer.toString(iTrackNumber));
        if (iTrackNumber < 0) {
            throw new ID3Exception("Track number cannot be negative.");
        }
        this.m_iTrackNumber = iTrackNumber;
        this.m_iTotalTracks = -1;
    }

    public TRCKTextInformationID3V2Frame(int iTrackNumber, int iTotalTracks) throws ID3Exception {
        super(Integer.toString(iTrackNumber) + "/" + Integer.toString(iTotalTracks));
        if (iTrackNumber < 0) {
            throw new ID3Exception("Track number cannot be negative.");
        }
        if (iTotalTracks < iTrackNumber) {
            throw new ID3Exception("Total number of tracks must be at least as great as the track number.");
        }
        this.m_iTrackNumber = iTrackNumber;
        this.m_iTotalTracks = iTotalTracks;
    }

    public TRCKTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            if (this.m_sInformation.indexOf(47) == -1) {
                this.m_iTrackNumber = Integer.parseInt(this.m_sInformation);
                this.m_iTotalTracks = -1;
            } else {
                String[] asPart = this.m_sInformation.split("/", 2);
                this.m_iTrackNumber = Integer.parseInt(asPart[0]);
                this.m_iTotalTracks = Integer.parseInt(asPart[1]);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TRCK part number frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTRCKTextInformationID3V2Frame(this);
    }

    public void setTrackNumber(int iTrackNumber) throws ID3Exception {
        if (iTrackNumber < 0) {
            throw new ID3Exception("Part number cannot be negative.");
        }
        this.m_iTrackNumber = iTrackNumber;
        this.m_iTotalTracks = -1;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iTrackNumber);
    }

    public void setTrackNumberAndTotalTracks(int iTrackNumber, int iTotalTracks) throws ID3Exception {
        if (iTrackNumber < 0) {
            throw new ID3Exception("Track number cannot be negative.");
        }
        if (iTotalTracks < iTrackNumber) {
            throw new ID3Exception("Total number of tracks must be at least as great as the track number.");
        }
        this.m_iTrackNumber = iTrackNumber;
        this.m_iTotalTracks = iTotalTracks;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = iTrackNumber + "/" + iTotalTracks;
    }

    public int getTrackNumber() {
        return this.m_iTrackNumber;
    }

    public int getTotalTracks() throws ID3Exception {
        if (this.m_iTotalTracks != -1) {
            return this.m_iTotalTracks;
        }
        throw new ID3Exception("Total number of tracks not set.");
    }

    protected byte[] getFrameId() {
        return "TRCK".getBytes();
    }

    public String toString() {
        return "Track number/Position in set: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TRCKTextInformationID3V2Frame)) {
            return false;
        }
        TRCKTextInformationID3V2Frame oOtherTRCK = (TRCKTextInformationID3V2Frame)oOther;
        return this.m_iTrackNumber == oOtherTRCK.m_iTrackNumber && this.m_iTotalTracks == oOtherTRCK.m_iTotalTracks && this.m_oTextEncoding.equals(oOtherTRCK.m_oTextEncoding) && this.m_sInformation.equals(oOtherTRCK.m_sInformation);
    }
}

