/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import java.text.DecimalFormat;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TCOPTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iYear;
    private String m_sCopyrightMessage = null;

    public TCOPTextInformationID3V2Frame(int iYear, String sCopyrightMessage) throws ID3Exception {
        super(TCOPTextInformationID3V2Frame.getYearString(iYear) + " " + (sCopyrightMessage == null ? "" : sCopyrightMessage));
        if (iYear < 0 || iYear > 9999) {
            throw new ID3Exception("Year must be within the range from 1 to 9999.");
        }
        this.m_iYear = iYear;
        this.m_sCopyrightMessage = sCopyrightMessage;
    }

    public TCOPTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            String sYear = this.m_sInformation.substring(0, 4);
            if (!sYear.matches("(?uis)\\d+")) {
                throw new ID3Exception("Missing 4-digit year value.");
            }
            this.m_iYear = Integer.parseInt(sYear);
            if (this.m_sInformation.charAt(4) != ' ') {
                throw new ID3Exception("Missing space after year..");
            }
            this.m_sCopyrightMessage = this.m_sInformation.length() > 5 ? this.m_sInformation.substring(5) : "";
        }
        catch (Exception e) {
            this.m_iYear = 0;
            this.m_sCopyrightMessage = this.m_sInformation;
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTCOPTextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TCOP".getBytes();
    }

    public String toString() {
        return "Copyright message: [" + this.m_sInformation + "]";
    }

    public void setCopyright(int iYear, String sCopyrightMessage) {
        this.m_iYear = iYear;
        this.m_sCopyrightMessage = sCopyrightMessage;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = TCOPTextInformationID3V2Frame.getYearString(iYear) + " " + (sCopyrightMessage == null ? "" : sCopyrightMessage);
    }

    public int getCopyrightYear() {
        return this.m_iYear;
    }

    public String getCopyrightMessage() {
        return this.m_sCopyrightMessage;
    }

    private static String getYearString(int iYear) {
        DecimalFormat oNF = new DecimalFormat("0000");
        return oNF.format(iYear);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TCOPTextInformationID3V2Frame)) {
            return false;
        }
        TCOPTextInformationID3V2Frame oOtherTCOP = (TCOPTextInformationID3V2Frame)oOther;
        return this.m_iYear == oOtherTCOP.m_iYear && this.m_sCopyrightMessage.equals(oOtherTCOP.m_sCopyrightMessage) && this.m_oTextEncoding.equals(oOtherTCOP.m_oTextEncoding) && this.m_sInformation.equals(oOtherTCOP.m_sInformation);
    }
}

