/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class RVADID3V2Frame
extends ID3V2Frame {
    private byte[] m_abyData = null;

    public RVADID3V2Frame(byte[] abyData) throws ID3Exception {
        if (abyData == null) {
            throw new ID3Exception("Data byte array cannot be null in RVAD frame.");
        }
        this.m_abyData = abyData;
    }

    public RVADID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_abyData = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyData);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitRVADID3V2Frame(this);
    }

    public byte[] getFrameData() {
        return this.m_abyData;
    }

    protected byte[] getFrameId() {
        return "RVAD".getBytes();
    }

    public String toString() {
        return "Relative volume adjustment: Raw data size=[" + this.m_abyData.length + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_abyData);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof RVADID3V2Frame)) {
            return false;
        }
        RVADID3V2Frame oOtherRVAD = (RVADID3V2Frame)oOther;
        return Arrays.equals(this.m_abyData, oOtherRVAD.m_abyData);
    }
}

