/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Util;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class LINKID3V2Frame
extends ID3V2Frame {
    private byte[] m_abyFrameIdentifier = null;
    private String m_sURL = null;
    private String m_sAdditionalData = null;

    public LINKID3V2Frame(byte[] abyFrameIdentifier, String sURL, String sAdditionalData) throws ID3Exception {
        if (abyFrameIdentifier == null) {
            throw new ID3Exception("LINK frame requires frame identifier.");
        }
        if (abyFrameIdentifier.length != 4) {
            throw new ID3Exception("Frame identifiers must be four bytes in length in LINK frame.");
        }
        this.m_abyFrameIdentifier = abyFrameIdentifier;
        if (sURL == null || sURL.length() == 0) {
            throw new ID3Exception("LINK frame requires an URL.");
        }
        this.m_sURL = sURL;
        this.m_sAdditionalData = sAdditionalData;
    }

    public LINKID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_abyFrameIdentifier = new byte[4];
            oFrameDataID3DIS.readFully(this.m_abyFrameIdentifier);
            this.m_sURL = oFrameDataID3DIS.readStringToNull();
            if (oFrameDataID3DIS.available() > 0) {
                byte[] abyAdditionalData = new byte[oFrameDataID3DIS.available()];
                oFrameDataID3DIS.readFully(abyAdditionalData);
                this.m_sAdditionalData = new String(abyAdditionalData);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitLINKID3V2Frame(this);
    }

    public void setContents(byte[] abyFrameIdentifier, String sURL, String sAdditionalData) throws ID3Exception {
        byte[] abyOrigFrameIdentifier = this.m_abyFrameIdentifier;
        String sOrigURL = this.m_sURL;
        String sOrigAdditionalData = this.m_sAdditionalData;
        if (abyFrameIdentifier == null) {
            throw new ID3Exception("LINK frame requires frame identifier.");
        }
        if (abyFrameIdentifier.length != 4) {
            throw new ID3Exception("Frame identifiers must be four bytes in length in LINK frame.");
        }
        if (sURL == null || sURL.length() == 0) {
            throw new ID3Exception("LINK frame requires an URL.");
        }
        this.m_abyFrameIdentifier = abyFrameIdentifier;
        this.m_sURL = sURL;
        this.m_sAdditionalData = sAdditionalData;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_abyFrameIdentifier = abyOrigFrameIdentifier;
            this.m_sURL = sOrigURL;
            this.m_sAdditionalData = sOrigAdditionalData;
            throw e;
        }
    }

    public byte[] getFrameIdentifier() {
        return this.m_abyFrameIdentifier;
    }

    public String getLinkUrl() {
        return this.m_sURL;
    }

    public String getAdditionalData() {
        return this.m_sAdditionalData;
    }

    protected byte[] getFrameId() {
        return "LINK".getBytes();
    }

    public String toString() {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append("Link: Frame identifier=[" + ID3Util.convertBytesToHexString(this.m_abyFrameIdentifier, true) + "], URL=[" + this.m_sURL + "], Additional data=[" + this.m_sAdditionalData + "]");
        return sbOutput.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_abyFrameIdentifier);
        oIDOS.write(this.m_sURL.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.write(this.m_sAdditionalData.getBytes());
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof LINKID3V2Frame)) {
            return false;
        }
        LINKID3V2Frame oOtherLINK = (LINKID3V2Frame)oOther;
        return Arrays.equals(this.m_abyFrameIdentifier, oOtherLINK.m_abyFrameIdentifier) && (this.m_sURL == null && oOtherLINK.m_sURL == null || this.m_sURL.equals(oOtherLINK.m_sURL)) && this.m_sAdditionalData.equals(oOtherLINK.m_sAdditionalData);
    }
}

