/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class IPLSID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private SortedMap m_oPeopleMap = null;

    public IPLSID3V2Frame() {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_oPeopleMap = new TreeMap();
    }

    public IPLSID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTextEncoding = TextEncoding.getTextEncoding(oFrameDataID3DIS.readUnsignedByte());
            this.m_oPeopleMap = new TreeMap();
            while (oFrameDataID3DIS.available() > 0) {
                String sInvolvement = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
                String sPerson = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
                if (sInvolvement == null || sPerson == null) {
                    throw new ID3Exception("IPLS frame missing involvement or person.");
                }
                this.addInvolvedPerson(new InvolvedPerson(sInvolvement, sPerson));
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitIPLSID3V2Frame(this);
    }

    public void addInvolvedPerson(InvolvedPerson oInvolvedPerson) {
        if (!this.m_oPeopleMap.containsKey(oInvolvedPerson.getInvolvement())) {
            this.m_oPeopleMap.put(oInvolvedPerson.getInvolvement(), new TreeSet());
        }
        Set oIPSet = (Set)this.m_oPeopleMap.get(oInvolvedPerson.getInvolvement());
        oIPSet.add(oInvolvedPerson);
    }

    public InvolvedPerson[] getInvolvedPersons(String sInvolvement) {
        Set oIPSet = (Set)this.m_oPeopleMap.get(sInvolvement);
        if (oIPSet != null) {
            return oIPSet.toArray(new InvolvedPerson[0]);
        }
        return new InvolvedPerson[0];
    }

    public InvolvedPerson[] removedInvolvedPersons(String sInvolvement) {
        Set oIPSet = (Set)this.m_oPeopleMap.remove(sInvolvement);
        if (oIPSet != null) {
            return oIPSet.toArray(new InvolvedPerson[0]);
        }
        return new InvolvedPerson[0];
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    protected byte[] getFrameId() {
        return "IPLS".getBytes();
    }

    public String toString() {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append("InvolvedPersons: Involvments =");
        if (this.m_oPeopleMap.values().size() > 0) {
            Iterator oSetIter = this.m_oPeopleMap.values().iterator();
            while (oSetIter.hasNext()) {
                Set oInvolvedPersonSet = (Set)oSetIter.next();
                Iterator oIPIter = oInvolvedPersonSet.iterator();
                while (oIPIter.hasNext()) {
                    InvolvedPerson oIP = (InvolvedPerson)oIPIter.next();
                    sbOutput.append("\nInvolvement=" + oIP.getInvolvement() + ", Person=" + oIP.getPerson());
                }
            }
        } else {
            sbOutput.append(" none");
        }
        return sbOutput.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        Iterator oSetIter = this.m_oPeopleMap.values().iterator();
        while (oSetIter.hasNext()) {
            Set oInvolvedPersonSet = (Set)oSetIter.next();
            Iterator oIPIter = oInvolvedPersonSet.iterator();
            while (oIPIter.hasNext()) {
                InvolvedPerson oIP = (InvolvedPerson)oIPIter.next();
                oIDOS.write(oIP.getInvolvement().getBytes(this.m_oTextEncoding.getEncodingString()));
                if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
                    oIDOS.writeUnsignedByte(0);
                } else {
                    oIDOS.writeUnsignedByte(0);
                    oIDOS.writeUnsignedByte(0);
                }
                oIDOS.write(oIP.getPerson().getBytes(this.m_oTextEncoding.getEncodingString()));
                if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
                    oIDOS.writeUnsignedByte(0);
                    continue;
                }
                oIDOS.writeUnsignedByte(0);
                oIDOS.writeUnsignedByte(0);
            }
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof IPLSID3V2Frame)) {
            return false;
        }
        IPLSID3V2Frame oOtherIPLS = (IPLSID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherIPLS.m_oTextEncoding) && this.m_oPeopleMap.equals(oOtherIPLS.m_oPeopleMap);
    }

    public static class InvolvedPerson
    implements Comparable {
        private String m_sInvolvement = null;
        private String m_sPerson = null;

        public InvolvedPerson(String sInvolvement, String sPerson) throws ID3Exception {
            if (sInvolvement == null || sInvolvement.length() == 0) {
                throw new ID3Exception("Involved persons in IPLS frames must have a defined involvement.");
            }
            this.m_sInvolvement = sInvolvement;
            if (sPerson == null || sPerson.length() == 0) {
                throw new ID3Exception("Involved persons in IPLS frames must have a defined person name.");
            }
            this.m_sPerson = sPerson;
        }

        public String getInvolvement() {
            return this.m_sInvolvement;
        }

        public String getPerson() {
            return this.m_sPerson;
        }

        public int compareTo(Object oOther) {
            InvolvedPerson oIP = (InvolvedPerson)oOther;
            return this.m_sPerson.compareTo(oIP.m_sPerson);
        }

        public int hashCode() {
            return this.m_sPerson.hashCode();
        }

        public boolean equals(Object oOther) {
            if (oOther == null || !(oOther instanceof InvolvedPerson)) {
                return false;
            }
            InvolvedPerson oOtherIP = (InvolvedPerson)oOther;
            return (this.m_sInvolvement == null && oOtherIP.m_sInvolvement == null || this.m_sInvolvement.equals(oOtherIP.m_sInvolvement)) && (this.m_sPerson == null && oOtherIP.m_sPerson == null || this.m_sPerson.equals(oOtherIP.m_sPerson));
        }
    }
}

