/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class COMMID3V2Frame
extends ID3V2Frame {
    private TextEncoding m_oTextEncoding;
    private String m_sLanguage = null;
    private String m_sShortDescription = null;
    private String m_sActualText = null;

    public COMMID3V2Frame(String sLanguage, String sShortDescription, String sActualText) throws ID3Exception {
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("Language string in COMM frame must have length of 3.");
        }
        this.m_sLanguage = sLanguage;
        this.m_sShortDescription = sShortDescription;
        if (this.m_sShortDescription == null) {
            this.m_sShortDescription = "";
        }
        if (sActualText == null) {
            throw new ID3Exception("Comment text is required in COMM frame.");
        }
        this.m_sActualText = sActualText;
    }

    public COMMID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            byte byTextEncoding = (byte)oFrameDataID3DIS.readUnsignedByte();
            this.m_oTextEncoding = TextEncoding.getTextEncoding(byTextEncoding);
            byte[] abyLanguage = new byte[3];
            oFrameDataID3DIS.readFully(abyLanguage);
            this.m_sLanguage = new String(abyLanguage);
            this.m_sShortDescription = oFrameDataID3DIS.readStringToNull(this.m_oTextEncoding);
            byte[] abyActualText = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(abyActualText);
            this.m_sActualText = new String(abyActualText, this.m_oTextEncoding.getEncodingString());
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitCOMMID3V2Frame(this);
    }

    public void setComment(String sLanguage, String sShortDescription, String sActualText) throws ID3Exception {
        TextEncoding oOrigTextEncoding = this.m_oTextEncoding;
        String sOrigLanguage = this.m_sLanguage;
        String sOrigShortDescription = this.m_sShortDescription;
        String sOrigActualText = this.m_sActualText;
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("Language string in COMM frame must have length of 3.");
        }
        if (sActualText == null) {
            throw new ID3Exception("Comment text is required in COMM frame.");
        }
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sLanguage = sLanguage;
        this.m_sShortDescription = sShortDescription;
        if (this.m_sShortDescription == null) {
            this.m_sShortDescription = "";
        }
        this.m_sActualText = sActualText;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sLanguage = sOrigLanguage;
            this.m_sShortDescription = sShortDescription;
            this.m_sActualText = sOrigActualText;
            this.m_oTextEncoding = oOrigTextEncoding;
            throw e;
        }
    }

    public void setTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        this.m_oTextEncoding = oTextEncoding;
    }

    public TextEncoding getTextEncoding() {
        return this.m_oTextEncoding;
    }

    public void setLanguage(String sLanguage) throws ID3Exception {
        String sOrigLanguage = this.m_sLanguage;
        if (sLanguage == null || sLanguage.length() != 3) {
            throw new ID3Exception("Language string in COMM frame must have length of 3.");
        }
        this.m_sLanguage = sLanguage;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sLanguage = sOrigLanguage;
            throw e;
        }
    }

    public String getLanguage() {
        return this.m_sLanguage;
    }

    public String getShortDescription() {
        return this.m_sShortDescription;
    }

    public String getActualText() {
        return this.m_sActualText;
    }

    protected byte[] getFrameId() {
        return "COMM".getBytes();
    }

    public String toString() {
        return "Comment: Language=[" + this.m_sLanguage + "], Short description=[" + this.m_sShortDescription + "], Actual text=[" + this.m_sActualText + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTextEncoding.getEncodingValue());
        oIDOS.write(this.m_sLanguage.getBytes());
        if (this.m_sShortDescription != null) {
            oIDOS.write(this.m_sShortDescription.getBytes(this.m_oTextEncoding.getEncodingString()));
        }
        if (this.m_oTextEncoding.equals(TextEncoding.ISO_8859_1)) {
            oIDOS.writeUnsignedByte(0);
        } else {
            oIDOS.writeUnsignedByte(0);
            oIDOS.writeUnsignedByte(0);
        }
        oIDOS.write(this.m_sActualText.getBytes(this.m_oTextEncoding.getEncodingString()));
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof COMMID3V2Frame)) {
            return false;
        }
        COMMID3V2Frame oOtherCOMM = (COMMID3V2Frame)oOther;
        return this.m_oTextEncoding.equals(oOtherCOMM.m_oTextEncoding) && this.m_sLanguage.equals(oOtherCOMM.m_sLanguage) && this.m_sShortDescription.equals(oOtherCOMM.m_sShortDescription) && this.m_sActualText.equals(oOtherCOMM.m_sActualText);
    }
}

