/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v1;

import java.io.OutputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v1.ID3V1Tag;

public class ID3V1_1Tag
extends ID3V1Tag {
    private int m_iAlbumTrack = 0;

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitID3V1_1Tag(this);
    }

    public void setComment(String sComment) {
        if (sComment.length() > 28) {
            sComment = sComment.substring(0, 28);
        }
        this.m_sComment = sComment;
    }

    public void setAlbumTrack(int iAlbumTrack) throws ID3Exception {
        if (iAlbumTrack <= 0 || iAlbumTrack >= 256) {
            throw new ID3Exception("Illegal album track value " + iAlbumTrack + ".  Valid range from 1 to 255.");
        }
        this.m_iAlbumTrack = iAlbumTrack;
    }

    public int getAlbumTrack() {
        return this.m_iAlbumTrack;
    }

    public String toString() {
        return super.toString() + "\nAlbumTrack = " + this.m_iAlbumTrack;
    }

    public void write(OutputStream oOS) throws ID3Exception {
        try {
            oOS.write("TAG".getBytes());
            if (this.getTitle() != null) {
                byte[] abySongTitle = this.getTitle().getBytes();
                oOS.write(abySongTitle);
                oOS.write(new byte[30 - abySongTitle.length]);
            } else {
                oOS.write(new byte[30]);
            }
            if (this.getArtist() != null) {
                byte[] abyArtist = this.getArtist().getBytes();
                oOS.write(abyArtist);
                oOS.write(new byte[30 - abyArtist.length]);
            } else {
                oOS.write(new byte[30]);
            }
            if (this.getAlbum() != null) {
                byte[] abyAlbum = this.getAlbum().getBytes();
                oOS.write(abyAlbum);
                oOS.write(new byte[30 - abyAlbum.length]);
            } else {
                oOS.write(new byte[30]);
            }
            if (this.getYear() != null) {
                byte[] abyYear = this.getYear().getBytes();
                oOS.write(abyYear);
                oOS.write(new byte[4 - abyYear.length]);
            } else {
                oOS.write(new byte[4]);
            }
            if (this.getComment() != null) {
                byte[] abyComment = this.getComment().getBytes();
                oOS.write(abyComment);
                oOS.write(new byte[28 - abyComment.length]);
            } else {
                oOS.write(new byte[28]);
            }
            oOS.write(0);
            oOS.write(this.getAlbumTrack());
            if (this.getGenre() != null) {
                oOS.write(this.getGenre().getByteValue());
            } else {
                oOS.write(0);
            }
        }
        catch (Exception e) {
            throw new ID3Exception(e);
        }
    }
}

