/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;

public class ID3DataInputStream
extends DataInputStream {
    public ID3DataInputStream(InputStream oIS) {
        super(oIS);
    }

    public final int readBEUnsigned16() throws IOException {
        int iHi = this.readUnsignedByte();
        int iLo = this.readUnsignedByte();
        int iVal = iLo | iHi << 8;
        return iVal;
    }

    public int readBE24() throws IOException {
        int iThree = this.readUnsignedByte();
        int iTwo = this.readUnsignedByte();
        int iOne = this.readUnsignedByte();
        int iVal = iOne | iTwo << 8 | iThree << 16;
        return iVal;
    }

    public int readBE32() throws IOException {
        int iFour = this.readUnsignedByte();
        int iThree = this.readUnsignedByte();
        int iTwo = this.readUnsignedByte();
        int iOne = this.readUnsignedByte();
        int iVal = iOne | iTwo << 8 | iThree << 16 | iFour << 24;
        return iVal;
    }

    public long readUnsignedBE32() throws IOException {
        long lFour = this.readUnsignedByte();
        long lThree = this.readUnsignedByte();
        long lTwo = this.readUnsignedByte();
        long lOne = this.readUnsignedByte();
        long lVal = lOne | lTwo << 8 | lThree << 16 | lFour << 24;
        return lVal;
    }

    public int readID3Four() throws IOException, ID3Exception {
        int iValue = 0;
        byte[] abyValue = new byte[4];
        this.readFully(abyValue);
        if ((abyValue[0] & 0x80) != 0 || (abyValue[1] & 0x80) != 0 || (abyValue[2] & 0x80) != 0 || (abyValue[3] & 0x80) != 0) {
            throw new ID3Exception("High bit cannot be set in encoded values.");
        }
        iValue |= (abyValue[0] & 0x7F) << 21;
        iValue |= (abyValue[1] & 0x7F) << 14;
        iValue |= (abyValue[2] & 0x7F) << 7;
        return iValue |= (abyValue[3] & 0x7F) << 0;
    }

    public String readStringToNull() throws IOException {
        return this.readStringToNull(Integer.MAX_VALUE);
    }

    public String readStringToNull(int iMaxLength) throws IOException {
        int iStringByte;
        ByteArrayOutputStream oStringBAOS = new ByteArrayOutputStream();
        do {
            if ((iStringByte = this.readUnsignedByte()) == 0) continue;
            if (oStringBAOS.size() == iMaxLength) {
                throw new IOException("String length exceeds set " + iMaxLength + " byte limit.");
            }
            oStringBAOS.write(iStringByte);
        } while (iStringByte != 0);
        byte[] abyShortDescription = oStringBAOS.toByteArray();
        return new String(abyShortDescription);
    }

    public String readStringToNull(TextEncoding oTextEncoding) throws IOException {
        return this.readStringToNull(oTextEncoding, Integer.MAX_VALUE);
    }

    public String readStringToNull(TextEncoding oTextEncoding, int iMaxLength) throws IOException {
        int iStringByte1;
        if (oTextEncoding == null) {
            throw new NullPointerException("Text encoding cannot be null.");
        }
        ByteArrayOutputStream oStringBAOS = new ByteArrayOutputStream();
        int iStringByte2 = 0;
        int iLength = 0;
        do {
            iStringByte1 = this.readUnsignedByte();
            if (oTextEncoding.equals(TextEncoding.UNICODE)) {
                iStringByte2 = this.readUnsignedByte();
            }
            if (iStringByte1 == 0 && iStringByte2 == 0) continue;
            if (iLength == iMaxLength) {
                throw new IOException("String length exceeds set " + iMaxLength + " byte limit.");
            }
            oStringBAOS.write(iStringByte1);
            if (oTextEncoding.equals(TextEncoding.UNICODE)) {
                oStringBAOS.write(iStringByte2);
            }
            ++iLength;
        } while (iStringByte1 != 0 || iStringByte2 != 0);
        byte[] abyShortDescription = oStringBAOS.toByteArray();
        return new String(abyShortDescription, oTextEncoding.getEncodingString());
    }
}

