/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.blinkenlights.jid3.io.IFileSource;

public class FileSource
implements IFileSource {
    private File m_oFile;

    public FileSource(File oFile) {
        this.m_oFile = oFile;
    }

    public IFileSource createTempFile(String sPrefix, String sSuffix) throws IOException {
        File oTmpFile = File.createTempFile("id3.", ".tmp", this.m_oFile.getAbsoluteFile().getParentFile());
        return new FileSource(oTmpFile);
    }

    public boolean delete() {
        return this.m_oFile.delete();
    }

    public String getName() {
        return this.m_oFile.getName();
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.m_oFile);
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.m_oFile);
    }

    public long length() {
        return this.m_oFile.length();
    }

    public boolean renameTo(String sFilename) {
        return this.m_oFile.renameTo(new File(sFilename));
    }

    public boolean renameTo(IFileSource oFileSource) throws IOException {
        if (!(oFileSource instanceof FileSource)) {
            throw new IOException("Cannot rename between different file source types.");
        }
        return this.m_oFile.renameTo(((FileSource)oFileSource).m_oFile);
    }

    public String toString() {
        return this.m_oFile.toString();
    }
}

