/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyHashUtil {
    private RubyHashUtil() {
    }

    public static RubyHash convertMapToRubyHashWithSymbols(Ruby rubyRuntime, Map<String, Object> options) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> optionsSet = options.entrySet();
        for (Map.Entry<String, Object> entry : optionsSet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            RubySymbol newSymbol = RubyHashUtil.toSymbol(rubyRuntime, key);
            IRubyObject iRubyValue = RubyHashUtil.toRubyObject(rubyRuntime, value);
            rubyHash.put((Object)newSymbol, (Object)iRubyValue);
        }
        return rubyHash;
    }

    public static Map<String, Object> convertRubyHashMapToMap(Map<RubySymbol, Object> rubyHashMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<Map.Entry<RubySymbol, Object>> elements = rubyHashMap.entrySet();
        for (Map.Entry<RubySymbol, Object> element : elements) {
            map.put(RubyHashUtil.toJavaString(element), RubyHashUtil.toJavaObject(element.getValue()));
        }
        return map;
    }

    private static String toJavaString(Map.Entry<RubySymbol, Object> element) {
        return element.getKey().asJavaString();
    }

    private static Object toJavaObject(Object rubyObject) {
        if (rubyObject instanceof IRubyObject) {
            IRubyObject iRubyObject = (IRubyObject)rubyObject;
            return JavaEmbedUtils.rubyToJava((IRubyObject)iRubyObject);
        }
        return rubyObject;
    }

    private static RubySymbol toSymbol(Ruby rubyRuntime, String key) {
        RubySymbol newSymbol = RubySymbol.newSymbol((Ruby)rubyRuntime, (String)key);
        return newSymbol;
    }

    private static IRubyObject toRubyObject(Ruby rubyRuntime, Object value) {
        if (value instanceof Map) {
            return RubyHashUtil.toNoneSymbolsRubyHash(rubyRuntime, (Map)value);
        }
        IRubyObject iRubyObject = JavaEmbedUtils.javaToRuby((Ruby)rubyRuntime, (Object)value);
        return iRubyObject;
    }

    public static RubyHash toNoneSymbolsRubyHash(Ruby rubyRuntime, Map<String, Object> map) {
        RubyHash rubyHash = new RubyHash(rubyRuntime);
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            rubyHash.put(RubyHashUtil.toJavaObject(entry.getKey()), RubyHashUtil.toJavaObject(entry.getValue()));
        }
        return rubyHash;
    }
}

