/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.parser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.LambdaExpression;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import javax.el.ValueReference;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.parser.AstLambdaExpression;
import org.apache.el.parser.AstMethodParameters;
import org.apache.el.parser.Node;
import org.apache.el.parser.SimpleNode;
import org.apache.el.stream.Optional;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        Class result = ctx.getELResolver().getType((ELContext)ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
        return result;
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren();
        int i = 1;
        ELResolver resolver = ctx.getELResolver();
        while (i < propCount) {
            if (i + 2 < propCount && this.children[i + 1] instanceof AstMethodParameters) {
                base = resolver.invoke((ELContext)ctx, base, this.children[i].getValue(ctx), null, ((AstMethodParameters)this.children[i + 1]).getParameters(ctx));
                i += 2;
            } else if (i + 2 == propCount && this.children[i + 1] instanceof AstMethodParameters) {
                ctx.setPropertyResolved(false);
                property = this.children[i].getValue(ctx);
                i += 2;
                if (property == null) {
                    throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
                }
            } else if (i + 1 < propCount) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                base = resolver.getValue((ELContext)ctx, base, property);
                ++i;
            } else {
                ctx.setPropertyResolved(false);
                property = this.children[i].getValue(ctx);
                ++i;
                if (property == null) {
                    throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
                }
            }
            if (base != null) continue;
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        int i = 1;
        Object suffix = null;
        ELResolver resolver = ctx.getELResolver();
        while (base != null && i < propCount) {
            suffix = this.children[i].getValue(ctx);
            if (i + 1 < propCount && this.children[i + 1] instanceof AstMethodParameters) {
                Node paramFoOptional;
                AstMethodParameters mps = (AstMethodParameters)this.children[i + 1];
                if (base instanceof Optional && "orElseGet".equals(suffix) && mps.jjtGetNumChildren() == 1 && !((paramFoOptional = mps.jjtGetChild(0)) instanceof AstLambdaExpression) && !(paramFoOptional instanceof LambdaExpression)) {
                    throw new ELException(MessageFactory.get("stream.optional.paramNotLambda", suffix));
                }
                Object[] paramValues = mps.getParameters(ctx);
                base = resolver.invoke((ELContext)ctx, base, suffix, (Class[])this.getTypesFromValues(paramValues), paramValues);
                i += 2;
                continue;
            }
            if (suffix == null) {
                return null;
            }
            ctx.setPropertyResolved(false);
            base = resolver.getValue((ELContext)ctx, base, suffix);
            ++i;
        }
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", base, suffix));
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        boolean result = ctx.getELResolver().isReadOnly((ELContext)ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
        return result;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ELResolver resolver = ctx.getELResolver();
        Class targetClass = resolver.getType((ELContext)ctx, t.base, t.property);
        resolver.setValue((ELContext)ctx, t.base, t.property, ELSupport.coerceToType(value, targetClass));
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes, null);
        return new MethodInfo(m.getName(), m.getReturnType(), (Class[])m.getParameterTypes());
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = null;
        Object[] values = null;
        Class[] types = null;
        if (this.isParametersProvided()) {
            values = ((AstMethodParameters)this.jjtGetChild(this.jjtGetNumChildren() - 1)).getParameters(ctx);
            types = this.getTypesFromValues(values);
        } else {
            values = paramValues;
            types = paramTypes;
        }
        m = ReflectionUtil.getMethod(t.base, t.property, types, values);
        values = this.convertArgs(values, m);
        Object result = null;
        try {
            result = m.invoke(t.base, values);
        }
        catch (IllegalAccessException iae) {
            throw new ELException((Throwable)iae);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof ThreadDeath) {
                throw (ThreadDeath)cause;
            }
            if (cause instanceof VirtualMachineError) {
                throw (VirtualMachineError)cause;
            }
            throw new ELException(cause);
        }
        return result;
    }

    private Object[] convertArgs(Object[] src, Method m) {
        Class<?>[] types = m.getParameterTypes();
        if (types.length == 0) {
            return new Object[0];
        }
        int paramCount = types.length;
        Object[] dest = new Object[paramCount];
        for (int i = 0; i < paramCount - 1; ++i) {
            dest[i] = ELSupport.coerceToType(src[i], types[i]);
        }
        if (m.isVarArgs()) {
            Object[] varArgs = (Object[])Array.newInstance(m.getParameterTypes()[paramCount - 1].getComponentType(), src.length - (paramCount - 1));
            for (int i = 0; i < src.length - (paramCount - 1); ++i) {
                varArgs[i] = ELSupport.coerceToType(src[paramCount - 1 + i], types[paramCount - 1].getComponentType());
            }
            dest[paramCount - 1] = varArgs;
        } else {
            dest[paramCount - 1] = ELSupport.coerceToType(src[paramCount - 1], types[paramCount - 1]);
        }
        return dest;
    }

    private Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        if (this.children.length > 2 && this.jjtGetChild(2) instanceof AstMethodParameters) {
            return null;
        }
        Target t = this.getTarget(ctx);
        return new ValueReference(t.base, t.property);
    }

    @Override
    public boolean isParametersProvided() {
        int len = this.children.length;
        return len > 2 && this.jjtGetChild(len - 1) instanceof AstMethodParameters;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

