/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class URLEncoder {
    private static final char[] hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final URLEncoder DEFAULT = new URLEncoder();
    protected final BitSet safeCharacters = new BitSet(256);

    public URLEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    @Deprecated
    public String encode(String path) {
        return this.encode(path, "UTF-8");
    }

    public String encode(String path, String encoding) {
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    static {
        DEFAULT.addSafeCharacter('~');
        DEFAULT.addSafeCharacter('-');
        DEFAULT.addSafeCharacter('_');
        DEFAULT.addSafeCharacter('.');
        DEFAULT.addSafeCharacter('*');
        DEFAULT.addSafeCharacter('/');
    }
}

