/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.mbeans.MBeanDumper;
import org.apache.tomcat.util.modeler.Registry;

public class JMXProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected transient MBeanServer mBeanServer = null;
    protected transient Registry registry;

    public void init() throws ServletException {
        this.registry = Registry.getRegistry(null, null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/plain");
        PrintWriter writer = response.getWriter();
        if (this.mBeanServer == null) {
            writer.println("Error - No mbean server");
            return;
        }
        String qry = request.getParameter("set");
        if (qry != null) {
            String name = request.getParameter("att");
            String val = request.getParameter("val");
            this.setAttribute(writer, qry, name, val);
            return;
        }
        qry = request.getParameter("get");
        if (qry != null) {
            String name = request.getParameter("att");
            this.getAttribute(writer, qry, name);
            return;
        }
        qry = request.getParameter("invoke");
        if (qry != null) {
            String opName = request.getParameter("op");
            String ps = request.getParameter("ps");
            String[] valuesStr = ps == null ? new String[]{} : ps.split(",");
            this.invokeOperation(writer, qry, opName, valuesStr);
            return;
        }
        qry = request.getParameter("qry");
        if (qry == null) {
            qry = "*:*";
        }
        this.listBeans(writer, qry);
    }

    public void getAttribute(PrintWriter writer, String onameStr, String att) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            Object value = this.mBeanServer.getAttribute(oname, att);
            writer.println("OK - Attribute get '" + onameStr + "' - " + att + "= " + MBeanDumper.escape(value.toString()));
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
            ex.printStackTrace(writer);
        }
    }

    public void setAttribute(PrintWriter writer, String onameStr, String att, String val) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            String type = this.registry.getType(oname, att);
            Object valueObj = this.registry.convertValue(type, val);
            this.mBeanServer.setAttribute(oname, new Attribute(att, valueObj));
            writer.println("OK - Attribute set");
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
            ex.printStackTrace(writer);
        }
    }

    public void listBeans(PrintWriter writer, String qry) {
        Set<ObjectName> names = null;
        try {
            names = this.mBeanServer.queryNames(new ObjectName(qry), null);
            writer.println("OK - Number of results: " + names.size());
            writer.println();
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
            ex.printStackTrace(writer);
            return;
        }
        String dump = MBeanDumper.dumpBeans(this.mBeanServer, names);
        writer.print(dump);
    }

    public boolean isSupported(String type) {
        return true;
    }

    private void invokeOperation(PrintWriter writer, String onameStr, String op, String[] valuesStr) {
        try {
            ObjectName oname = new ObjectName(onameStr);
            MBeanOperationInfo methodInfo = this.registry.getMethodInfo(oname, op);
            MBeanParameterInfo[] signature = methodInfo.getSignature();
            String[] signatureTypes = new String[signature.length];
            Object[] values = new Object[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                MBeanParameterInfo pi = signature[i];
                signatureTypes[i] = pi.getType();
                values[i] = this.registry.convertValue(pi.getType(), valuesStr[i]);
            }
            Object retVal = this.mBeanServer.invoke(oname, op, values, signatureTypes);
            writer.println("OK - Operation " + op + " returned:");
            this.output("", writer, retVal);
        }
        catch (Exception ex) {
            writer.println("Error - " + ex.toString());
            ex.printStackTrace(writer);
        }
    }

    private void output(String indent, PrintWriter writer, Object result) {
        if (result instanceof Object[]) {
            for (Object obj : (Object[])result) {
                this.output("  " + indent, writer, obj);
            }
        } else {
            writer.println(indent + result.toString());
        }
    }
}

