/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.annotations.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONWriter.class);
    public static final boolean ENUM_AS_BEAN_DEFAULT = false;
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private StringBuilder buf = new StringBuilder();
    private Stack stack = new Stack();
    private boolean ignoreHierarchy = true;
    private Object root;
    private boolean buildExpr = true;
    private String exprStack = "";
    private Collection<Pattern> excludeProperties;
    private Collection<Pattern> includeProperties;
    private DateFormat formatter;
    private boolean enumAsBean = false;
    private boolean excludeNullProperties;

    JSONWriter() {
    }

    public String write(Object object) throws JSONException {
        return this.write(object, null, null, false);
    }

    public String write(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean excludeNullProperties) throws JSONException {
        this.excludeNullProperties = excludeNullProperties;
        this.buf.setLength(0);
        this.root = object;
        this.exprStack = "";
        this.buildExpr = excludeProperties != null && !excludeProperties.isEmpty() || includeProperties != null && !includeProperties.isEmpty();
        this.excludeProperties = excludeProperties;
        this.includeProperties = includeProperties;
        this.value(object, null);
        return this.buf.toString();
    }

    private void value(Object object, Method method) throws JSONException {
        if (object == null) {
            this.add("null");
            return;
        }
        if (this.stack.contains(object)) {
            Class<?> clazz = object.getClass();
            if (clazz.isPrimitive() || clazz.equals(String.class)) {
                this.process(object, method);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cyclic reference detected on " + object, new String[0]);
                }
                this.add("null");
            }
            return;
        }
        this.process(object, method);
    }

    private void process(Object object, Method method) throws JSONException {
        this.stack.push(object);
        if (object instanceof Class) {
            this.string(object);
        } else if (object instanceof Boolean) {
            this.bool((Boolean)object);
        } else if (object instanceof Number) {
            this.add(object);
        } else if (object instanceof String) {
            this.string(object);
        } else if (object instanceof Character) {
            this.string(object);
        } else if (object instanceof Map) {
            this.map((Map)object, method);
        } else if (object.getClass().isArray()) {
            this.array(object, method);
        } else if (object instanceof Iterable) {
            this.array(((Iterable)object).iterator(), method);
        } else if (object instanceof Date) {
            this.date((Date)object, method);
        } else if (object instanceof Calendar) {
            this.date(((Calendar)object).getTime(), method);
        } else if (object instanceof Locale) {
            this.string(object);
        } else if (object instanceof Enum) {
            this.enumeration((Enum)object);
        } else {
            this.bean(object);
        }
        this.stack.pop();
    }

    private void bean(Object object) throws JSONException {
        this.add("{");
        try {
            Class<?> clazz = object.getClass();
            BeanInfo info = object == this.root && this.ignoreHierarchy ? Introspector.getBeanInfo(clazz, clazz.getSuperclass()) : Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            boolean hasData = false;
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                Method accessor = prop.getReadMethod();
                Method baseAccessor = null;
                if (clazz.getName().indexOf("$$EnhancerByCGLIB$$") > -1) {
                    try {
                        baseAccessor = Class.forName(clazz.getName().substring(0, clazz.getName().indexOf("$$"))).getMethod(accessor.getName(), accessor.getParameterTypes());
                    }
                    catch (Exception ex) {
                        LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
                    }
                } else if (clazz.getName().indexOf("$$_javassist") > -1) {
                    try {
                        baseAccessor = Class.forName(clazz.getName().substring(0, clazz.getName().indexOf("_$$"))).getMethod(accessor.getName(), accessor.getParameterTypes());
                    }
                    catch (Exception ex) {
                        LOG.debug(ex.getMessage(), (Throwable)ex, new String[0]);
                    }
                } else {
                    baseAccessor = accessor;
                }
                if (baseAccessor == null) continue;
                JSON json = baseAccessor.getAnnotation(JSON.class);
                if (json != null) {
                    if (!json.serialize()) continue;
                    if (json.name().length() > 0) {
                        name = json.name();
                    }
                }
                if (this.shouldExcludeProperty(clazz, prop)) continue;
                String expr = null;
                if (this.buildExpr) {
                    expr = this.expandExpr(name);
                    if (this.shouldExcludeProperty(expr)) continue;
                    expr = this.setExprStack(expr);
                }
                Object value = accessor.invoke(object, new Object[0]);
                boolean propertyPrinted = this.add(name, value, accessor, hasData);
                boolean bl = hasData = hasData || propertyPrinted;
                if (!this.buildExpr) continue;
                this.setExprStack(expr);
            }
            if (object instanceof Enum) {
                String value = ((Enum)object).name();
                this.add("_name", value, object.getClass().getMethod("name", new Class[0]), hasData);
            }
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        this.add("}");
    }

    private void enumeration(Enum enumeration) throws JSONException {
        if (this.enumAsBean) {
            this.bean(enumeration);
        } else {
            this.string(enumeration.name());
        }
    }

    private boolean shouldExcludeProperty(Class clazz, PropertyDescriptor prop) throws SecurityException, NoSuchFieldException {
        String name = prop.getName();
        return name.equals("class") || name.equals("declaringClass") || name.equals("cachedSuperClass") || name.equals("metaClass");
    }

    private String expandExpr(int i) {
        return this.exprStack + "[" + i + "]";
    }

    private String expandExpr(String property) {
        if (this.exprStack.length() == 0) {
            return property;
        }
        return this.exprStack + "." + property;
    }

    private String setExprStack(String expr) {
        String s = this.exprStack;
        this.exprStack = expr;
        return s;
    }

    private boolean shouldExcludeProperty(String expr) {
        if (this.excludeProperties != null) {
            for (Pattern pattern : this.excludeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring property because of exclude rule: " + expr, new String[0]);
                }
                return true;
            }
        }
        if (this.includeProperties != null) {
            for (Pattern pattern : this.includeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring property because of include rule:  " + expr, new String[0]);
            }
            return true;
        }
        return false;
    }

    private boolean add(String name, Object value, Method method, boolean hasData) throws JSONException {
        if (!this.excludeNullProperties || value != null) {
            if (hasData) {
                this.add(',');
            }
            this.add('\"');
            this.add(name);
            this.add("\":");
            this.value(value, method);
            return true;
        }
        return false;
    }

    private void map(Map map, Method method) throws JSONException {
        this.add("{");
        Iterator it = map.entrySet().iterator();
        boolean warnedNonString = false;
        boolean hasData = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            String expr = null;
            if (this.buildExpr) {
                if (key == null) {
                    LOG.error("Cannot build expression for null key in " + this.exprStack, new String[0]);
                    continue;
                }
                expr = this.expandExpr(key.toString());
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            if (!warnedNonString && !(key instanceof String)) {
                LOG.warn("JavaScript doesn't support non-String keys, using toString() on " + key.getClass().getName(), new String[0]);
                warnedNonString = true;
            }
            this.value(key.toString(), method);
            this.add(":");
            this.value(entry.getValue(), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("}");
    }

    private void date(Date date, Method method) {
        JSON json = null;
        if (method != null) {
            json = method.getAnnotation(JSON.class);
        }
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        DateFormat formatter = json != null && json.format().length() > 0 ? new SimpleDateFormat(json.format()) : this.formatter;
        this.string(formatter.format(date));
    }

    /*
     * Unable to fully structure code
     */
    private void array(Iterator it, Method method) throws JSONException {
        this.add("[");
        hasData = false;
        i = 0;
        while (it.hasNext()) {
            expr = null;
            if (!this.buildExpr) ** GOTO lbl13
            expr = this.expandExpr(i);
            if (this.shouldExcludeProperty(expr)) {
                it.next();
            } else {
                expr = this.setExprStack(expr);
lbl13:
                // 2 sources

                if (hasData) {
                    this.add(',');
                }
                hasData = true;
                this.value(it.next(), method);
                if (this.buildExpr) {
                    this.setExprStack(expr);
                }
            }
            ++i;
        }
        this.add("]");
    }

    private void array(Object object, Method method) throws JSONException {
        this.add("[");
        int length = Array.getLength(object);
        boolean hasData = false;
        for (int i = 0; i < length; ++i) {
            String expr = null;
            if (this.buildExpr) {
                expr = this.expandExpr(i);
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            this.value(Array.get(object, i), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("]");
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void add(char c) {
        this.buf.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setEnumAsBean(boolean enumAsBean) {
        this.enumAsBean = enumAsBean;
    }
}

